/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class EEnumCellEditor
extends ComboBoxCellEditor {
    private List list;

    public static EEnumCellEditor createInstance(Composite parent, EEnum type) {
        return new EEnumCellEditor(parent, EEnumCellEditor.getEnumItems(type));
    }

    protected EEnumCellEditor(Composite parent, List values) {
        super(parent, EEnumCellEditor.getItemLabels(values, true));
        this.list = values;
    }

    public Object doGetValue() {
        int index = (Integer)super.doGetValue();
        return index < this.list.size() && index >= 0 ? ((EEnumLiteral)this.list.get((Integer)super.doGetValue())).getInstance() : null;
    }

    public void doSetValue(Object value) {
        for (EEnumLiteral literal : this.list) {
            if (literal.getValue() != ((Enumerator)value).getValue()) continue;
            super.doSetValue((Object)new Integer(this.list.indexOf(literal)));
        }
    }

    private static List getEnumItems(EEnum enumType) {
        ArrayList enumerators = new ArrayList();
        Iterator iter = enumType.getELiterals().iterator();
        while (iter.hasNext()) {
            enumerators.add(iter.next());
        }
        return enumerators;
    }

    private static String[] getItemLabels(List list, boolean sorted) {
        String[] result;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (EEnumLiteral literal : list) {
                result[i] = literal.getName();
                ++i;
            }
        } else {
            result = new String[]{""};
        }
        return result;
    }
}

