/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30;

import java.util.List;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class MethodSelector {
    private MethodInfo method;
    private Combo methodCombo;
    private List<MethodInfo> methods;

    public MethodSelector(Composite parent) {
        this.methodCombo = FormBuilder.createCombo((Composite)parent, (int)8, (int)1);
        this.methodCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = MethodSelector.this.methodCombo.getSelectionIndex();
                MethodSelector.this.method = index < 1 ? null : (MethodInfo)MethodSelector.this.methods.get(index - 1);
            }
        });
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public Combo getMethodCombo() {
        return this.methodCombo;
    }

    public void setMethodsList(List<MethodInfo> methods) {
        this.methods = methods;
        this.methodCombo.removeAll();
        this.methodCombo.add("");
        for (MethodInfo methodInfo : methods) {
            this.methodCombo.add(methodInfo.getLabel());
        }
    }

    public void setMethodName(String methodName) {
        if (this.methods != null) {
            int i = 0;
            while (i < this.methods.size()) {
                MethodInfo method = this.methods.get(i);
                if (method.getEncoded().equals(methodName)) {
                    this.methodCombo.select(i + 1);
                    this.method = method;
                    break;
                }
                ++i;
            }
        }
    }

    public String getMethodName() {
        return this.method == null ? null : this.method.getEncoded();
    }
}

