/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private List<String> prefixes;

    public SortedProperties(List<String> prefixes) {
        this.prefixes = prefixes;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        TreeSet<Object> set = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int result = 0;
                String fullKey1 = o1.toString();
                String fullKey2 = o2.toString();
                int i1 = fullKey1.lastIndexOf(46);
                int i2 = fullKey2.lastIndexOf(46);
                if (i1 < 0 && i2 >= 0) {
                    result = -1;
                } else if (i2 < 0 && i1 >= 0) {
                    result = 1;
                } else if (i1 < 0 && i2 < 0) {
                    result = fullKey1.compareTo(fullKey2);
                } else {
                    String key1 = fullKey1.substring(i1 + 1);
                    String key2 = fullKey2.substring(i2 + 1);
                    String qualifier1 = fullKey1.substring(0, i1);
                    String qualifier2 = fullKey2.substring(0, i2);
                    i1 = SortedProperties.this.prefixes.indexOf(qualifier1);
                    i2 = SortedProperties.this.prefixes.indexOf(qualifier2);
                    result = i1 < 0 && i2 >= 0 ? -1 : (i2 < 0 && i1 >= 0 ? 1 : (i1 < 0 && i2 < 0 ? qualifier1.compareTo(qualifier2) : i1 - i2));
                    if (result == 0) {
                        result = key1.compareTo(key2);
                    }
                }
                return result;
            }
        });
        Enumeration<Object> en = super.keys();
        while (en.hasMoreElements()) {
            set.add(en.nextElement());
        }
        return Collections.enumeration(set);
    }
}

