/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.ui.parts.tree;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

abstract class LazyLoadingTreeEditPart
extends AbstractTreeEditPart {
    private static List DUMMY = Collections.singletonList(new EObjectDescriptor(null, null, "invisible", "invisible", null, null, null));
    private Adapter notificationAdapter;
    private boolean expanded;
    private TreeListener listener = new TreeListener(){

        public void treeCollapsed(TreeEvent e) {
        }

        public void treeExpanded(TreeEvent e) {
            if (e.item == LazyLoadingTreeEditPart.this.getWidget()) {
                LazyLoadingTreeEditPart.this.expand();
            }
        }
    };

    public LazyLoadingTreeEditPart(Object model) {
        super(model);
    }

    protected Image getImage() {
        if (this.getModel() == null) {
            return null;
        }
        return this.doGetImage();
    }

    protected abstract Image doGetImage();

    protected String getText() {
        if (this.getModel() == null) {
            return Repository_Messages.TXT_INVISIBLE;
        }
        return this.doGetText();
    }

    protected abstract String doGetText();

    protected List getModelChildren() {
        if (!this.expanded && this.isLazyLoading()) {
            return DUMMY;
        }
        try {
            return this.doGetModelChildren();
        }
        catch (Throwable t) {
            if (t instanceof PublicException && t.getCause() != null) {
                t = ((PublicException)t).getCause();
            }
            return Collections.singletonList(new EObjectDescriptor(null, null, "Error", t.toString(), null, null, null));
        }
    }

    protected abstract List doGetModelChildren();

    protected boolean isLazyLoading() {
        return true;
    }

    public void setWidget(Widget widget) {
        TreeItem item;
        if (this.checkTreeItem()) {
            item = (TreeItem)this.getWidget();
            item.getParent().removeTreeListener(this.listener);
        }
        super.setWidget(widget);
        if (this.checkTreeItem()) {
            item = (TreeItem)widget;
            item.getParent().addTreeListener(this.listener);
            if (item.getExpanded()) {
                this.expand();
            }
        }
    }

    private void expand() {
        if (!this.expanded) {
            this.expanded = true;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    LazyLoadingTreeEditPart.this.refreshChildren();
                }
            });
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            EObject model = (EObject)this.getModel();
            if (model != null) {
                model.eAdapters().add((Object)this.getNotificationAdapter());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            EObject model = (EObject)this.getModel();
            if (model != null) {
                try {
                    model.eAdapters().remove((Object)this.getNotificationAdapter());
                }
                catch (Throwable throwable) {}
            }
            super.deactivate();
        }
    }

    private Adapter getNotificationAdapter() {
        if (this.notificationAdapter == null) {
            this.notificationAdapter = new Adapter(){
                private Notifier target;

                public void notifyChanged(Notification notification) {
                    LazyLoadingTreeEditPart.this.handleNotification(notification);
                }

                public Notifier getTarget() {
                    return this.target;
                }

                public void setTarget(Notifier newTarget) {
                    this.target = newTarget;
                }

                public boolean isAdapterForType(Object type) {
                    return type.equals(LazyLoadingTreeEditPart.this.getModel().getClass());
                }
            };
        }
        return this.notificationAdapter;
    }

    public void handleNotification(Notification n) {
        if (n.getPosition() != -1 || n.getEventType() == 5 || n.getEventType() == 6) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
        }
    }
}

