/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.defaulttemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.templates.emf.template.FeatureStyleType;
import org.eclipse.stardust.modeling.templates.emf.template.FeatureType;
import org.eclipse.stardust.modeling.templates.emf.template.ParameterType;
import org.eclipse.stardust.modeling.templates.emf.template.ReferenceType;
import org.eclipse.stardust.modeling.templates.emf.template.ScopeType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TemplateParameterWizardPage
extends WizardPage {
    private TemplateType template;
    private HashMap controlMapper;
    private ModelType model;
    private Map mapping;

    protected TemplateParameterWizardPage(ModelType targetModel, TemplateType template, Map mapping, ImageDescriptor titleImage) {
        super(template.getId(), template.getName(), titleImage);
        this.template = template;
        this.model = targetModel;
        this.mapping = mapping;
        this.controlMapper = new HashMap();
    }

    public void createControl(Composite parent) {
        parent.getShell().setText(this.template.getName());
        Composite composite = new Composite(parent, 128);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        composite.setLayoutData((Object)gd);
        EList<ReferenceType> roots = this.template.getRoots().getRoot();
        int i = 0;
        while (i < roots.size()) {
            ReferenceType ref = (ReferenceType)roots.get(i);
            EList<ParameterType> parameters = ref.getParameters();
            int j = 0;
            while (j < parameters.size()) {
                ParameterType parameter = (ParameterType)parameters.get(j);
                EObject sourceObject = parameter.getReference();
                EObject object = (EObject)this.mapping.get(sourceObject);
                String label = object.eClass().getName();
                if (object instanceof IIdentifiableElement) {
                    label = ((IIdentifiableElement)object).getName();
                }
                Group group = this.createGroup(composite, label);
                EList<FeatureType> features = parameter.getFeatures();
                int k = 0;
                while (k < features.size()) {
                    FeatureType feature = (FeatureType)features.get(k);
                    Label kind = new Label((Composite)group, 0);
                    label = feature.getLabel();
                    kind.setText(label == null ? String.valueOf(feature.getName()) + ":" : String.valueOf(label) + ":");
                    if (FeatureStyleType.SELECTION == feature.getType()) {
                        EClassifier eType;
                        EStructuralFeature structuralFeature;
                        Combo combo = new Combo((Composite)group, 8);
                        ComboViewer viewer = new ComboViewer(combo);
                        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                            public String getText(Object element) {
                                if (element instanceof IIdentifiableElement) {
                                    return ((IIdentifiableElement)element).getName();
                                }
                                return super.getText(element);
                            }
                        });
                        GridData data = new GridData(768);
                        data.widthHint = 200;
                        combo.setLayoutData((Object)data);
                        if (ScopeType.MODEL == feature.getScope() && (structuralFeature = object.eClass().getEStructuralFeature(feature.getName())) != null && (eType = structuralFeature.getEType()) instanceof EClass) {
                            EList containments = this.model.eClass().getEAllContainments();
                            int l = 0;
                            while (l < containments.size()) {
                                EStructuralFeature targetFeature = (EStructuralFeature)containments.get(l);
                                if (targetFeature.getEType() == eType) {
                                    ArrayList source = this.model.eGet(targetFeature);
                                    if (source instanceof List) {
                                        ArrayList copy = new ArrayList();
                                        copy.addAll(source);
                                        this.removeContainedParents(copy, object);
                                        source = copy;
                                    }
                                    viewer.setInput((Object)source);
                                    this.controlMapper.put(feature, viewer);
                                    combo.select(0);
                                }
                                ++l;
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.setControl((Control)composite);
        this.validateFields();
    }

    private void removeContainedParents(List copy, EObject object) {
        if (object.eContainer() == null) {
            return;
        }
        if (copy.contains(object)) {
            copy.remove(object);
        }
        this.removeContainedParents(copy, object.eContainer());
    }

    private void validateFields() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        return group;
    }

    public boolean finish(IProgressMonitor monitor) {
        for (Map.Entry entry : this.controlMapper.entrySet()) {
            StructuredViewer viewer;
            IStructuredSelection selection;
            FeatureType feature = (FeatureType)entry.getKey();
            Object control = entry.getValue();
            if (!(control instanceof StructuredViewer) || (selection = (IStructuredSelection)(viewer = (StructuredViewer)control).getSelection()).isEmpty()) continue;
            Object value = selection.getFirstElement();
            ParameterType parameter = (ParameterType)feature.eContainer();
            EObject object = (EObject)this.mapping.get(parameter.getReference());
            EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(feature.getName());
            object.eSet(structuralFeature, value);
        }
        return true;
    }
}

