/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.stardust.engine.core.javascript.StructuredDataListAccessor;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.JsValue;
import org.eclipse.stardust.modeling.transformation.debug.model.JsVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.NullElementVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapVariable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.Debugger;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        if (context instanceof JsStackFrame) {
            IWatchExpressionResult watchResult = WatchExpressionDelegate.evaluateExpression(expression, (JsStackFrame)context);
            listener.watchEvaluationFinished(watchResult);
        }
    }

    public static IWatchExpressionResult evaluateExpression(String expression, JsStackFrame frame) {
        return new JsWatchExpressionResult(frame, expression);
    }

    private static Object evaluateImpl(JsStackFrame frame, String expression, JsWatchExpressionResult watchExpressionResult) {
        Context jsContext = frame.getDebugFrame().getContext();
        Scriptable scope = frame.getDebugFrame().getScope();
        Debugger debugger = jsContext.getDebugger();
        if (debugger != null) {
            jsContext.setDebugger(null, null);
        }
        Object result = null;
        try {
            try {
                result = jsContext.evaluateString(scope, expression, expression, 1, null);
            }
            catch (RuntimeException x) {
                x.printStackTrace();
                watchExpressionResult.setException(new DebugException((IStatus)new Status(4, "org.eclipse.stardust.modeling.transformation.debug", x.getMessage(), (Throwable)x)));
                if (debugger != null) {
                    jsContext.setDebugger(debugger, null);
                }
            }
        }
        finally {
            if (debugger != null) {
                jsContext.setDebugger(debugger, null);
            }
        }
        return result;
    }

    private static final class JsWatchExpressionResult
    implements IWatchExpressionResult {
        private final JsStackFrame frame;
        private final String expression;
        private boolean evaluated = false;
        private IValue value = null;
        private DebugException exception = null;

        private JsWatchExpressionResult(JsStackFrame frame, String expression) {
            this.frame = frame;
            this.expression = expression;
        }

        public IValue getValue() {
            if (this.evaluated) {
                return this.value;
            }
            try {
                if (this.frame != null) {
                    Object rawResult = Context.call((ContextAction)new ContextAction(){

                        public Object run(Context arg0) {
                            try {
                                return WatchExpressionDelegate.evaluateImpl(JsWatchExpressionResult.this.frame, JsWatchExpressionResult.this.expression, JsWatchExpressionResult.this);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return null;
                            }
                        }
                    });
                    JsDebugElement variable = null;
                    if (rawResult == null) {
                        variable = new NullElementVariable(this.frame, "xyz");
                    } else if (rawResult instanceof StructuredDataMapAccessor) {
                        variable = new StructuredDataMapVariable(this.frame, null, "xyz", (StructuredDataMapAccessor)rawResult);
                    } else if (rawResult instanceof StructuredDataListAccessor) {
                        variable = new StructuredDataListVariable(this.frame, null, "xyz", (StructuredDataListAccessor)rawResult);
                    } else if (JsValue.isValidJsValue(rawResult)) {
                        boolean isPrimitive = rawResult.getClass().isPrimitive();
                        variable = new JsVariable(this.frame, null, "xyz", rawResult, isPrimitive);
                    }
                    if (variable != null) {
                        try {
                            this.value = variable.getValue();
                        }
                        catch (DebugException e) {
                            this.exception = e;
                        }
                    }
                }
            }
            finally {
                this.evaluated = true;
            }
            return this.value;
        }

        public boolean hasErrors() {
            return this.exception != null || this.getValue() == null;
        }

        public String[] getErrorMessages() {
            if (this.hasErrors()) {
                if (this.exception != null) {
                    return new String[]{this.exception.getMessage()};
                }
                return new String[]{"(Watch expression not supported)"};
            }
            return new String[0];
        }

        public String getExpressionText() {
            return this.expression;
        }

        public DebugException getException() {
            return this.exception;
        }

        private void setException(DebugException exception) {
            this.exception = exception;
        }
    }
}

