/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.common;

import org.eclipse.stardust.modeling.transformation.debug.common.SteppingMode;

public class SteppingManager {
    private int levelCounter;
    private SteppingMode requestedMode;

    public SteppingManager() {
        this.reset();
    }

    public void reset() {
        if (this.requestedTermination()) {
            return;
        }
        this.levelCounter = 0;
        this.requestedMode = SteppingMode.NONE;
    }

    public void recordEnter() {
        ++this.levelCounter;
    }

    public void recordExit() {
        --this.levelCounter;
    }

    public void setMode(SteppingMode mode) {
        if (this.requestedTermination()) {
            return;
        }
        this.requestedMode = mode;
    }

    public final boolean requestedTermination() {
        return SteppingMode.TERMINATE == this.requestedMode;
    }

    public boolean canSuspend() {
        switch (this.requestedMode) {
            case STEP_INTO: 
            case BREAK: {
                return true;
            }
            case STEP_OUT: {
                if (this.levelCounter >= 0) break;
                return true;
            }
            case STEP_OVER: {
                if (this.levelCounter > 0) break;
                return true;
            }
        }
        return false;
    }
}

