/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;

public abstract class AbstractVariable
extends JsDebugElement
implements IVariable {
    private final AbstractVariable parent;
    private final JsStackFrame frame;
    protected boolean hasChanged = false;

    public AbstractVariable(JsStackFrame frame, AbstractVariable parent) {
        super((JsDebugTarget)frame.getDebugTarget());
        this.parent = parent;
        this.frame = frame;
    }

    public AbstractVariable getParent() {
        return this.parent;
    }

    public String getQualifiedName() throws DebugException {
        return this.getName();
    }

    public JsStackFrame getFrame() {
        return this.frame;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(IValue value) throws DebugException {
        if (this.verifyValue(value)) {
            this.setValue(value.getValueString());
        }
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }
}

