/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopMultiInstanceType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.LoopDataRefType;
import org.eclipse.stardust.modeling.validation.AccessPathEvaluationContext;
import org.eclipse.stardust.modeling.validation.BridgeObjectProviderRegistry;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.StructDataMappingUtils;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class BridgeObject {
    private IType endClass;
    private final DirectionType direction;
    private final String label;

    public BridgeObject(IType endClass, DirectionType direction) {
        this.endClass = endClass;
        this.direction = direction;
        this.label = endClass == null ? null : endClass.getFullyQualifiedName();
    }

    public BridgeObject(IType endClass, DirectionType direction, String label) {
        this.endClass = endClass;
        this.direction = direction;
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public IType getEndClass() {
        return this.endClass;
    }

    public DirectionType getDirection() {
        return this.direction;
    }

    public boolean acceptAssignmentFrom(BridgeObject rhs) {
        if (this.direction == DirectionType.OUT_LITERAL) {
            return false;
        }
        if (rhs.direction == DirectionType.IN_LITERAL) {
            return false;
        }
        return TypeFinder.isAssignable(this.getEndClass(), rhs.getEndClass());
    }

    public static BridgeObject getBridge(ITypedElement ap, String path, DirectionType direction) throws ValidationException {
        return BridgeObject.getBridge(ap, path, direction, null);
    }

    public static BridgeObject getBridge(ITypedElement ap, String path, DirectionType direction, AccessPathEvaluationContext context) throws ValidationException {
        BridgeObject result;
        IBridgeObjectProvider bridgeProvider = BridgeObjectProviderRegistry.getBridgeObjectProvider(ap);
        if (bridgeProvider != null) {
            if (bridgeProvider instanceof AccessPathEvaluationContext.Aware) {
                ((AccessPathEvaluationContext.Aware)bridgeProvider).setContext(context);
            }
            result = bridgeProvider.getBridgeObject(ap, path, direction);
        } else {
            result = new BridgeObject(JavaDataTypeUtils.getTypeFromCurrentProject(Object.class.getName()), direction);
        }
        return result;
    }

    public static void checkMapping(ITypedElement left, String leftPath, ITypedElement right, String rightPath) throws ValidationException {
        BridgeObject.checkMapping(left, leftPath, right, rightPath, null, null);
    }

    public static void checkMapping(ITypedElement left, String leftPath, ITypedElement right, String rightPath, ActivityType activity) throws ValidationException {
        BridgeObject.checkMapping(left, leftPath, right, rightPath, activity, null);
    }

    public static void checkMapping(ITypedElement left, String leftPath, ITypedElement right, String rightPath, ActivityType activity, DataMappingType dataMapping) throws ValidationException {
        LoopType loop;
        LoopTypeType loopType;
        BridgeObject leftBridge = BridgeObject.getBridge(left, leftPath, DirectionType.IN_LITERAL, new AccessPathEvaluationContext(right, rightPath, activity));
        BridgeObject rightBridge = BridgeObject.getBridge(right, rightPath, DirectionType.OUT_LITERAL, new AccessPathEvaluationContext(left, leftPath, activity));
        if (StructDataMappingUtils.isVizRulesApplication((ActivityType)activity) && (BridgeObject.isAssignable(rightBridge.getEndClass(), Map.class) && BridgeObject.isAssignable(leftBridge.getEndClass(), Serializable.class) || BridgeObject.isAssignable(rightBridge.getEndClass(), Serializable.class) && BridgeObject.isAssignable(leftBridge.getEndClass(), Map.class))) {
            return;
        }
        if (activity != null && activity.getLoop() != null && (loopType = (loop = activity.getLoop()).getLoopType()).equals((Object)LoopTypeType.MULTI_INSTANCE)) {
            LoopMultiInstanceType loopMultiInstance = loop.getLoopMultiInstance();
            LoopDataRefType loopDataRef = loopMultiInstance.getLoopDataRef();
            String paramId = loopDataRef.getInputItemRef();
            IType endClass = rightBridge.getEndClass();
            if (left instanceof DataType) {
                paramId = loopDataRef.getOutputItemRef();
                endClass = leftBridge.getEndClass();
            }
            String compare = null;
            if (dataMapping != null) {
                compare = String.valueOf(dataMapping.getContext()) + ":" + dataMapping.getApplicationAccessPoint();
            }
            if (paramId != null && compare != null) {
                Class<?> compareclass = null;
                try {
                    compareclass = Class.forName(endClass.getFullyQualifiedName());
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (paramId.equals(compare) && compareclass != null && (List.class.isAssignableFrom(compareclass) || compareclass.isArray())) {
                    return;
                }
            }
        }
        if (!leftBridge.acceptAssignmentFrom(rightBridge)) {
            throw new ValidationException(MessageFormat.format(Validation_Messages.BridgeObject_assignmentNotCompatible, leftBridge, rightBridge), rightPath == null || rightPath.length() == 0 ? right : rightPath);
        }
    }

    private static boolean isAssignable(IType type, Class<?> clazz) {
        if (type == null || clazz == null) {
            return false;
        }
        try {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType clazzType = JavaDataTypeUtils.getTypeFromCurrentProject(clazz.getName());
            return typeHierarchy.contains(clazzType);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

