/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.actionTypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPointProvider;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class SetDataActionValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataId");
        DataType data = null;
        if (StringUtils.isEmpty((String)dataId)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_NoDataSpecified, (Object)"carnot:engine:dataId"));
        } else {
            data = ModelUtils.findData((IModelElement)element, (String)dataId);
            if (data == null) {
                result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_InvalidDataSpecified, (Object)"carnot:engine:dataId"));
            }
        }
        String srcApId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:attributeName");
        ITypedElement srcAp = null;
        if (StringUtils.isEmpty((String)srcApId)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_NoAccessPointSpecified, (Object)"carnot:engine:attributeName"));
        } else {
            Map dataTypes;
            IConfigurationElement config;
            EventHandlerType eventHandler = ModelUtils.findContainingEventHandlerType((EObject)element);
            if (eventHandler != null && (config = (IConfigurationElement)(dataTypes = SpiExtensionRegistry.instance().getExtensions("conditionTypes")).get(eventHandler.getMetaType().getId())) != null) {
                try {
                    IAccessPointProvider apProvider = (IAccessPointProvider)config.createExecutableExtension("accessPointProvider");
                    srcAp = (ITypedElement)ModelUtils.findIdentifiableElement((List)apProvider.createIntrinsicAccessPoint(element), (String)srcApId);
                }
                catch (CoreException coreException) {}
            }
            if (srcAp == null) {
                result.add(Issue.warning((EObject)element, (String)Validation_Messages.SetDataActionValidator_MSG_InvalidParam, (Object)"carnot:engine:attributeName"));
            }
        }
        if (data != null && srcAp != null) {
            String dataPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataPath");
            String srcApPath = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:attributePath");
            try {
                BridgeObject.checkMapping((ITypedElement)data, dataPath, srcAp, srcApPath);
            }
            catch (ValidationException e) {
                result.add(Issue.warning((EObject)element, (String)e.getMessage(), (Object)(StringUtils.isEmpty((String)srcApPath) ? "carnot:engine:attributeName" : "carnot:engine:attributePath")));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

