/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.dataTypes;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.validation.AccessPathEvaluationContext;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class PrimitiveValidator
implements IModelElementValidator,
IBridgeObjectProvider,
AccessPathEvaluationContext.Aware {
    private AccessPathEvaluationContext context;

    public Issue[] validate(IModelElement element) throws ValidationException {
        String type = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:type");
        if (StringUtils.isEmpty((String)type)) {
            return new Issue[]{Issue.warning((EObject)element, (String)Validation_Messages.MSG_PRIMITIVE_UnspecifiedType)};
        }
        if (type.equals(Type.Enumeration.toString())) {
            EObject ref = AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType");
            if (!(ref instanceof TypeDeclarationType) && !element.eIsProxy()) {
                return new Issue[]{Issue.error((EObject)element, (String)Validation_Messages.MSG_NoTypeDeclarationDefined, (Object)"carnot:engine:dataType")};
            }
            if (!element.eIsProxy()) {
                String defaultValue = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:defaultValue");
                if (StringUtils.isEmpty((String)defaultValue)) {
                    return new Issue[]{Issue.error((EObject)element, (String)Validation_Messages.MSG_NoEnumerationDefaultValue, (Object)"carnot:engine:defaultValue")};
                }
                if (ExtendedAttributeUtil.getAttribute((Extensible)((Extensible)ref), (String)"carnot:engine:className") == null) {
                    return new Issue[]{Issue.error((EObject)element, (String)Validation_Messages.MSG_TypeDeclarationNotJavaBoundEnum, (Object)"carnot:engine:dataType")};
                }
                XSDSimpleTypeDefinition def = TypeDeclarationUtils.getSimpleType((TypeDeclarationType)((TypeDeclarationType)ref));
                if (def != null) {
                    XSDEnumerationFacet effectiveFacet = def.getEffectiveEnumerationFacet();
                    for (Object value : effectiveFacet.getValue()) {
                        if (!defaultValue.equals(value)) continue;
                        return Issue.ISSUE_ARRAY;
                    }
                }
                return new Issue[]{Issue.error((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_InvalidEnumerationDefaultValue, defaultValue), (Object)"carnot:engine:defaultValue")};
            }
        }
        return Issue.ISSUE_ARRAY;
    }

    @Override
    public BridgeObject getBridgeObject(ITypedElement accessPoint, String accessPath, DirectionType direction) throws ValidationException {
        return JavaDataTypeUtils.getBridgeObject(accessPoint, accessPath, direction, this.context);
    }

    public void setContext(AccessPathEvaluationContext context) {
        this.context = context;
    }
}

