/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.triggerTypes;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.Period;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class TimerTriggerValidator
implements IModelElementValidator {
    private static final short ZERO = 0;
    private static final String DEFAULT_PERIOD = new Period(0, 0, 0, 0, 0, 0).toString();

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        String periodicityAtt;
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:startTime"))) {
            result.add(Issue.error((EObject)element, Validation_Messages.MSG_TIMERTRIGGER_UnspecifiedStart));
        }
        if (!StringUtils.isEmpty((String)(periodicityAtt = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:periodicity"))) && DEFAULT_PERIOD.equals(periodicityAtt)) {
            result.add(Issue.warning((EObject)element, Validation_Messages.TimerTrigger_InvalidPeriodicity));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

