/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.editor;

import org.eclipse.stardust.ide.simulation.ui.curves.editor.Editor;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;

public class EditorController
implements MouseListener,
MouseMoveListener {
    static final int DRAG_EPS = 1;
    static final int TARGET_EPS = 2;
    Point drag;
    Editor editor;
    Rectangle2D sensivity = new Rectangle2D(new Coord2D(-2.0, -2.0), new Coord2D(2.0, 2.0));

    public EditorController(Editor editor) {
        this.editor = editor;
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        Point mouse = new Point(event.x, event.y);
        Coord2D screen = Coord2D.swt2model(mouse);
        Coord2D graticule = this.editor.getMetrics().transposeToValue(screen);
        this.editor.updateSensivity(this.editor.getMetrics().transposeToValue(this.sensivity));
        this.editor.actionExecute(graticule, (event.stateMask & 0x40000) != 0);
        this.drag = null;
    }

    public void mouseSingleClick(MouseEvent event) {
        Point mouse = new Point(event.x, event.y);
        Coord2D screen = Coord2D.swt2model(mouse);
        Coord2D graticule = this.editor.getMetrics().transposeToValue(screen);
        this.editor.updateSensivity(this.editor.getMetrics().transposeToValue(this.sensivity));
        if (event.button == 1) {
            this.editor.actionSelect(graticule, (event.stateMask & 0x40000) != 0);
        } else if (event.button == 3) {
            this.editor.actionPopup(graticule, (event.stateMask & 0x40000) != 0);
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            this.drag = new Point(event.x, event.y);
        }
        this.mouseSingleClick(event);
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.drag != null) {
            Point mouse = new Point(event.x, event.y);
            if (this.isDrag(this.drag, mouse)) {
                Coord2D screen0 = Coord2D.swt2model(this.drag);
                Coord2D graticule0 = this.editor.getMetrics().transposeToValue(screen0);
                Coord2D screen1 = Coord2D.swt2model(mouse);
                Coord2D graticule1 = this.editor.getMetrics().transposeToValue(screen1);
                this.editor.actionDragCommit(graticule0, graticule1.minus(graticule0), graticule1);
            } else {
                this.editor.actionDragAbort();
            }
        }
        this.drag = null;
    }

    private boolean isDrag(Point p1, Point p2) {
        return Math.abs(p1.x - p2.x) > 1 || Math.abs(p1.y - p2.y) > 1;
    }

    public void mouseMove(MouseEvent event) {
        Point mouse = new Point(event.x, event.y);
        if (this.drag != null) {
            if (this.isDrag(this.drag, mouse)) {
                Coord2D screen0 = Coord2D.swt2model(this.drag);
                Coord2D graticule0 = this.editor.getMetrics().transposeToValue(screen0);
                Coord2D screen1 = Coord2D.swt2model(mouse);
                Coord2D graticule1 = this.editor.getMetrics().transposeToValue(screen1);
                this.editor.actionDragPreview(graticule0, graticule1.minus(graticule0), graticule1);
            }
        } else {
            Coord2D screen = Coord2D.swt2model(mouse);
            Coord2D graticule = this.editor.getMetrics().transposeToValue(screen);
            this.editor.updateSensivity(this.editor.getMetrics().transposeToValue(this.sensivity));
            this.editor.actionMovePreview(graticule);
        }
    }
}

