/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.geometry;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;

public class Rectangle2D {
    Coord2D lt;
    Coord2D rb;

    public Rectangle2D(Rectangle2D other) {
        this.lt = new Coord2D(other.lt);
        this.rb = new Coord2D(other.rb);
    }

    public Rectangle2D(Coord2D corner1, Coord2D corner2) {
        this.lt = new Coord2D(Math.min(corner1.x, corner2.x), Math.min(corner1.y, corner2.y));
        this.rb = new Coord2D(Math.max(corner1.x, corner2.x), Math.max(corner1.y, corner2.y));
    }

    public Rectangle2D(double x, double y, double w, double h) {
        this(new Coord2D(x, y), new Coord2D(x + w, y + h));
    }

    public Coord2D getMinCorner() {
        return new Coord2D(this.lt);
    }

    public Coord2D getMaxCorner() {
        return new Coord2D(this.rb);
    }

    public Coord2D getSize() {
        return new Coord2D(this.rb.x - this.lt.x, this.rb.y - this.lt.y);
    }

    public Rectangle2D transform(Coord2D p) {
        return new Rectangle2D(this.lt.plus(p), this.rb.plus(p));
    }

    public Rectangle2D scale(Coord2D p) {
        return new Rectangle2D(this.lt.multiply(p.x), this.rb.multiply(p.y));
    }

    public Rectangle2D scale(double d) {
        return new Rectangle2D(this.lt.multiply(d), this.rb.multiply(d));
    }

    public Rectangle2D extend(Coord2D c) {
        if (c.x < this.lt.x || c.y < this.lt.y || c.x > this.rb.x || c.y > this.rb.y) {
            return new Rectangle2D(this.lt.min(c), this.rb.max(c));
        }
        return this;
    }

    public Rectangle2D extend(Rectangle2D r) {
        return this.extend(r.lt).extend(r.rb);
    }

    public boolean inside(Coord2D c) {
        return this.lt.x <= c.x && this.lt.y <= c.y && c.x <= this.rb.x && c.y <= this.rb.y;
    }

    public Coord2D adjust(Coord2D c) {
        return c.max(this.getMinCorner()).min(this.getMaxCorner());
    }

    public static Rectangle2D swt2model(org.eclipse.swt.graphics.Rectangle p) {
        return new Rectangle2D(p.x, p.y, p.width, p.height);
    }

    public static org.eclipse.swt.graphics.Rectangle model2swt(Rectangle2D p) {
        return new org.eclipse.swt.graphics.Rectangle((int)Math.round(p.getMinCorner().x), (int)Math.round(p.getMinCorner().y), (int)Math.round(p.getSize().x), (int)Math.round(p.getSize().y));
    }

    public static Rectangle2D draw2d2model(Rectangle p) {
        return new Rectangle2D(p.x, p.y, p.width, p.height);
    }
}

