/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForMap;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForModel;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class SimulationConfiguration {
    public static final String CURRENT_SIMULATION_CONFIGURATION_ATTRIBUTE = "currentSimulationConfigurationId";
    public static final String NEXT_SIMULATION_CONFIGURATION_ID_ATTRIBUTE = "nextSimulationConfigurationId";
    public static final String SIMULATION_CONFIGURATION_ID_LIST_ATTRIBUTE = "simulationConfigurationIds";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String INTERVAL_START_ATTRIBUTE = "intervalStart";
    public static final String INTERVAL_END_ATTRIBUTE = "intervalEnd";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS";
    private int id;
    private String name;
    private String description;
    private Date intervalStart;
    private Date intervalEnd;

    public SimulationConfiguration(int id, String name, String description, Date intervalStart, Date intervalEnd) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.setIntervalStart(intervalStart);
        this.setIntervalEnd(intervalEnd);
    }

    public SimulationConfiguration(int id, Map attributeMap) {
        this(id, new AttributeAccessForMap(attributeMap, ""));
    }

    public SimulationConfiguration(int id, ModelType model) {
        this(id, new AttributeAccessForModel((IExtensibleElement)model, ""));
    }

    public SimulationConfiguration(int id, AttributeAccessAdapter attributes) {
        this.id = id;
        String prefix = "carnot:simulation:configuration:simulationConfiguration[" + id + "].";
        this.setName(attributes.getAttibute(String.valueOf(prefix) + NAME_ATTRIBUTE, "Undefined"));
        this.setDescription(attributes.getAttibute(String.valueOf(prefix) + DESCRIPTION_ATTRIBUTE, "Undefined"));
        String intervalStartValue = attributes.getAttibute(String.valueOf(prefix) + INTERVAL_START_ATTRIBUTE, null);
        if (intervalStartValue != null) {
            try {
                Date date = this.createDateFormat().parse(intervalStartValue);
                this.setIntervalStart(date);
            }
            catch (ParseException parseException) {
                this.setIntervalStartDefault("error while parsing '" + intervalStartValue + "'");
            }
        } else {
            this.setIntervalStartDefault("missing or incompatible configuration setting");
        }
        String intervalEndValue = attributes.getAttibute(String.valueOf(prefix) + INTERVAL_END_ATTRIBUTE, null);
        if (intervalEndValue != null) {
            try {
                Date date = this.createDateFormat().parse(intervalEndValue);
                this.setIntervalEnd(date);
            }
            catch (ParseException parseException) {
                this.setIntervalEndDefault("error while parsing '" + intervalEndValue + "'");
            }
        } else {
            this.setIntervalEndDefault("missing or incompatible configuration setting");
        }
        if (!this.getIntervalEnd().after(this.getIntervalStart())) {
            this.setIntervalEndDefault("end date was before start date");
        }
    }

    private DateFormat createDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getIntervalEnd() {
        return this.intervalEnd;
    }

    public void setIntervalEnd(Date intervalEnd) {
        this.intervalEnd = new TimeCalculator(intervalEnd).moveToEndOfDay().toDate();
    }

    public void setIntervalEndDefault(String reason) {
        if (this.getIntervalStart() == null) {
            this.setIntervalStartDefault(reason);
        }
        this.setIntervalEnd(new TimeCalculator(this.getIntervalStart()).add(1, 1).toDate());
        System.out.println("Error in SimulationConfiguration " + this.getId());
        System.out.println("\tEnd of simulation interval set to default(" + this.getIntervalEnd() + ")");
        System.out.println("\tbecause of following reason: " + reason);
    }

    public Date getIntervalStart() {
        return this.intervalStart;
    }

    public void setIntervalStart(Date intervalStart) {
        this.intervalStart = new TimeCalculator(intervalStart).moveToBeginOfDay().toDate();
    }

    public void setIntervalStartDefault(String reason) {
        this.setIntervalStart(new Date());
        System.out.println("Error in SimulationConfiguration " + this.getId());
        System.out.println("\tStart of simulation interval set to default(" + this.getIntervalStart() + ")");
        System.out.println("\tbecause of following reason: " + reason);
    }

    public SimulationInterval getInterval() {
        return new SimulationInterval(this.intervalStart, this.intervalEnd);
    }

    public String toString() {
        return this.name;
    }

    public void writeSimulationConfigurationToModel(AttributeAccessAdapter attributes) {
        String prefix = "carnot:simulation:configuration:simulationConfiguration[" + this.getId() + "].";
        System.out.println("getIntervalStart(): " + this.getIntervalStart());
        System.out.println("getIntervalEnd(): " + this.getIntervalEnd());
        attributes.setAttibute(String.valueOf(prefix) + NAME_ATTRIBUTE, this.getName());
        attributes.setAttibute(String.valueOf(prefix) + DESCRIPTION_ATTRIBUTE, this.getDescription());
        attributes.setAttibute(String.valueOf(prefix) + INTERVAL_START_ATTRIBUTE, this.getIntervalStart() == null ? "" : this.createDateFormat().format(this.getIntervalStart()));
        attributes.setAttibute(String.valueOf(prefix) + INTERVAL_END_ATTRIBUTE, this.getIntervalEnd() == null ? "" : this.createDateFormat().format(this.getIntervalEnd()));
    }
}

