/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.commongui;

import org.eclipse.stardust.ide.simulation.ui.commongui.VerificationStatusHandler;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyIntegerFormat;

public class VerifyIntegerMinMax
extends VerifyIntegerFormat {
    int min;
    int max;

    public VerifyIntegerMinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public VerifyIntegerMinMax(int min, int max, VerificationStatusHandler errorHandler) {
        super(errorHandler);
        this.min = min;
        this.max = max;
    }

    @Override
    protected boolean isValid(String text) {
        if (this.min >= 0 && text.startsWith("-")) {
            return false;
        }
        return super.isValid(text);
    }

    @Override
    protected boolean isReady(String text) {
        return super.isReady(text) && this.isInRange(Integer.parseInt(text));
    }

    private boolean isInRange(int i) {
        return this.min <= i && i <= this.max;
    }

    @Override
    public int fromString(String text) {
        return Math.max(this.min, Math.min(this.max, super.fromString(text)));
    }
}

