/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Random;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.BooleanGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class BooleanGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_BOOLEAN;
    public static final String OPTION_PROBABILITY = "probability";
    Random random = new Random(System.currentTimeMillis());

    public BooleanGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_PROBABILITY, "50");
    }

    @Override
    public Object getRandom() {
        return new Boolean(this.random.nextInt(100) < this.getProbability());
    }

    @Override
    public Class getResultClass() {
        return Boolean.class;
    }

    protected int getProbability() {
        return Integer.parseInt(this.getOption(OPTION_PROBABILITY));
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new BooleanGeneratorPanel(parent, this);
    }

    @Override
    public boolean isComplete() {
        try {
            Integer.parseInt(this.getOption(OPTION_PROBABILITY));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

