/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Random;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.CharacterGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class CharacterGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_CHARACTER;
    public static final String OPTION_CHARACTERS = "characters";
    Random random = new Random(System.currentTimeMillis());

    public CharacterGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_CHARACTERS, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Override
    public Object getRandom() {
        String characters = this.getCharacters();
        return new Character(characters.charAt(this.random.nextInt(characters.length())));
    }

    @Override
    public Class getResultClass() {
        return Character.class;
    }

    protected String getCharacters() {
        return this.getOption(OPTION_CHARACTERS);
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new CharacterGeneratorPanel(parent, this);
    }

    @Override
    public boolean isComplete() {
        return !StringUtils.isEmpty((String)this.getCharacters());
    }
}

