/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;

public class DurationConfiguration
extends AbstractRetrievableSimulationSubConfiguration {
    private String unitId = "SECOND";
    private IDistributionConfiguration distribution;

    public DurationConfiguration(SimulationInterval simulationInterval) {
        super(simulationInterval);
    }

    public String getUnitId() {
        return this.unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId != null ? unitId : "SECOND";
    }

    public IDistributionConfiguration getDistribution() {
        return this.distribution;
    }

    public void setDistribution(IDistributionConfiguration distribution) {
        this.distribution = distribution;
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            super.read(attributes);
            this.setUnitId(attributes.getAttibute("duration:unit", DistributionUtils.getDefaultFor("duration:unit")));
            String distributionTypeId = attributes.getAttibute("distribution:type", DistributionUtils.getDefaultFor("distribution:type"));
            if (distributionTypeId != null) {
                DistributionFactory distributionFactory = new DistributionFactory(this.interval);
                this.distribution = distributionFactory.create(distributionTypeId);
                this.distribution.read(attributes);
            }
        }
        catch (Exception e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        super.write(attributes);
        attributes.setAttibute("duration:unit", this.getUnitId());
        if (this.distribution != null) {
            attributes.setAttibute("distribution:type", this.distribution.getDistributionTypeId());
            this.distribution.write(attributes);
        } else {
            attributes.setAttibute("distribution:type", null);
        }
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return this.distribution != null ? this.distribution.getBoundValues() : null;
    }

    @Override
    protected String getFromAuditTrailAttributeName() {
        return "duration:fromAuditTrail";
    }

    @Override
    public boolean isComplete() {
        return !this.isNull() && this.distribution != null && this.distribution.isComplete();
    }
}

