/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.model.xpdl.carnot.impl.CarnotWorkflowModelPackageImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceFactoryImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.ModelOidUtil;
import org.w3c.dom.Document;

public class WorkflowModelManager {
    static final String PROXY_ATT = "proxy";
    private static final String EXT_CWM = "cwm";
    private static final String PROTOCOL_VCS = "vcs";
    protected Resource resource = null;
    private static CarnotWorkflowModelFactory cwmFactory = null;
    protected ModelType model = null;
    private ModelOidUtil modelOidUtil;

    public ModelOidUtil getModelOidUtil() {
        return this.modelOidUtil;
    }

    public WorkflowModelManager() {
    }

    public WorkflowModelManager(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource(URI resourceUri) {
        if (this.resource == null) {
            ResourceSet resSet = this.getResourceSet();
            resSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resource = resSet.getResource(resourceUri, true);
        }
        return this.resource;
    }

    public Resource getResource(URI resourceUri, boolean loadOnDemand) {
        if (this.resource == null) {
            ResourceSet resSet = this.getResourceSet();
            resSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resource = resSet.getResource(resourceUri, loadOnDemand);
            if (this.resource == null) {
                this.resource = resSet.createResource(resourceUri);
            }
        }
        return this.resource;
    }

    private Resource createResource(URI uri) {
        if (this.resource == null) {
            ResourceSet resSet = this.getResourceSet();
            this.resource = resSet.createResource(uri);
        }
        return this.resource;
    }

    protected ResourceSet getResourceSet() {
        Map contentTypeMap;
        CarnotWorkflowModelPackageImpl.init();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map extensionMap = reg.getExtensionToFactoryMap();
        if (!extensionMap.containsKey(EXT_CWM)) {
            extensionMap.put(EXT_CWM, new CarnotWorkflowModelResourceFactoryImpl());
        }
        if (!extensionMap.containsKey("xpdl")) {
            extensionMap.put("xpdl", new CarnotWorkflowModelResourceFactoryImpl());
        }
        if (!(contentTypeMap = reg.getProtocolToFactoryMap()).containsKey(PROTOCOL_VCS)) {
            contentTypeMap.put(PROTOCOL_VCS, new CarnotWorkflowModelResourceFactoryImpl());
        }
        return new ResourceSetImpl();
    }

    public static CarnotWorkflowModelFactory getFactory() {
        if (cwmFactory == null) {
            cwmFactory = CarnotWorkflowModelFactory.eINSTANCE;
        }
        return cwmFactory;
    }

    public ModelType createModel(URI uri) {
        this.createResource(uri);
        CarnotWorkflowModelFactory cwmFactory = WorkflowModelManager.getFactory();
        DocumentRoot documentRoot = cwmFactory.createDocumentRoot();
        this.resource.getContents().add((Object)documentRoot);
        documentRoot.setModel(cwmFactory.createModelType());
        this.model = documentRoot.getModel();
        this.resolve(this.model);
        return this.model;
    }

    public void load(URI uri) throws IOException {
        this.load(uri, null);
    }

    public void load(File file) throws IOException {
        this.load(URI.createFileURI((String)file.getAbsolutePath()));
    }

    public void load(URI uri, InputStream is) throws IOException {
        this.getResource(uri, false);
        this.doLoad(is);
    }

    protected void doLoad(InputStream is) throws IOException {
        Map options = CollectionUtils.newMap();
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        if (is == null) {
            this.resource.load(options);
        } else {
            try {
                this.resource.load(is, options);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.fixNamespaces();
    }

    private void fixNamespaces() {
        EObject obj = (EObject)this.resource.getContents().get(0);
        if (obj instanceof DocumentRoot) {
            EMap<String, String> map = ((DocumentRoot)obj).getXMLNSPrefixMap();
            String xpdlKey = null;
            List namespaces = CollectionUtils.newList();
            List duplicatedNSKeys = CollectionUtils.newList();
            Set keySet = map.keySet();
            for (String nsKey : keySet) {
                if (nsKey.startsWith("_") || !this.checkNamespace(map, namespaces, duplicatedNSKeys, nsKey) || xpdlKey != null) continue;
                xpdlKey = nsKey;
            }
            for (String nsKey : keySet) {
                if (!nsKey.startsWith("_") || !this.checkNamespace(map, namespaces, duplicatedNSKeys, nsKey) || xpdlKey != null) continue;
                xpdlKey = nsKey;
            }
            for (String nsKey : duplicatedNSKeys) {
                map.removeKey((Object)nsKey);
            }
            if (xpdlKey != null) {
                map.remove(xpdlKey);
            }
            map.put((Object)"xpdl", (Object)"http://www.wfmc.org/2008/XPDL2.1");
        }
    }

    private boolean checkNamespace(EMap<String, String> map, List<String> namespaces, List<String> duplicatedNSKeys, String nsKey) {
        String ns = (String)map.get((Object)nsKey);
        if (namespaces.contains(ns)) {
            duplicatedNSKeys.add(nsKey);
        } else {
            namespaces.add(ns);
        }
        return "http://www.wfmc.org/2008/XPDL2.1".equals(ns);
    }

    public void reload(URI uri) throws IOException {
        this.getResource(uri, false).unload();
        this.load(uri);
    }

    public void save(URI uri) throws IOException {
        this.save(uri, null);
    }

    public void save(File file) throws IOException {
        this.save(URI.createFileURI((String)file.getAbsolutePath()));
    }

    public void save(URI uri, OutputStream os) throws IOException {
        this.getResource(uri, false);
        if (this.resource != null && !CompareHelper.areEqual((Object)this.resource.getURI(), (Object)uri)) {
            this.resource.setURI(uri);
        }
        this.doSave(os);
    }

    protected void doSave(OutputStream os) throws IOException {
        Map options = CollectionUtils.newMap();
        options.put("ENCODING", "ISO-8859-1");
        URI uri = this.resource.getURI();
        if (uri.fileExtension() != null && uri.fileExtension().endsWith("xpdl") && this.resource instanceof CarnotWorkflowModelResourceImpl) {
            Document domCwm = ((XMLResource)this.resource).save(null, options, null);
            if (domCwm != null) {
                StreamSource xsltSource;
                try {
                    URL xsltURL = XpdlUtils.getCarnot2XpdlStylesheet();
                    if (xsltURL == null) {
                        throw new InternalException("Unable to find XPDL export stylesheet.");
                    }
                    xsltSource = new StreamSource(xsltURL.openStream());
                }
                catch (IOException e) {
                    throw new PublicException(Model_Messages.EXC_INVALID_JAXP_SETUP, (Throwable)e);
                }
                ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
                try {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        StreamResult target = new StreamResult(os == null ? ((CarnotWorkflowModelResourceImpl)this.resource).getNewOutputStream() : os);
                        TransformerFactory transformerFactory = XmlUtils.newTransformerFactory();
                        Transformer xpdlTrans = transformerFactory.newTransformer(xsltSource);
                        XmlUtils.transform((Source)new DOMSource(domCwm), (Transformer)xpdlTrans, (Result)target, null, (int)3, (String)"UTF-8");
                    }
                    catch (TransformerConfigurationException e) {
                        throw new PublicException(Model_Messages.EXC_INVALID_JAXP_SETUP, (Throwable)e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cclBackup);
                }
            }
        } else if (os == null) {
            this.resource.save(options);
        } else {
            this.resource.save(os, options);
        }
    }

    public ModelType getModel() {
        if (this.model == null && this.resource != null) {
            EList l = this.resource.getContents();
            for (EObject o : l) {
                if (!(o instanceof DocumentRoot)) continue;
                this.model = ((DocumentRoot)o).getModel();
            }
            if (this.model != null) {
                this.resolve(this.model);
            }
        }
        return this.model;
    }

    public void resolve(ModelType model) {
        long maxUsedOid = ModelUtils.getMaxUsedOid(model);
        this.modelOidUtil = ModelOidUtil.register(model, maxUsedOid, this.resource);
        ModelUtils.resolve(model, model);
    }
}

