/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.audittrail;

import ag.carnot.thirdparty.db.derby.DerbyDbActivator;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.persistence.jdbc.Session;
import org.eclipse.stardust.engine.core.runtime.beans.SchemaHelper;
import org.eclipse.stardust.modeling.audittrail.AuditTrailActivator;
import org.eclipse.stardust.modeling.audittrail.AuditTrailManagementException;
import org.eclipse.stardust.modeling.audittrail.EmbeddedDerbySessionTemplate;
import org.eclipse.stardust.modeling.audittrail.EmbeddedDerbyTemplate;
import org.eclipse.stardust.modeling.audittrail.Messages;
import org.eclipse.stardust.modeling.audittrail.SqlTemplate;

public class AuditTrailDbManager {
    public static final String DEFAULT_AUDIT_TRAIL_NAME = "carnot";

    public static IFolder findDb(String dbName) {
        IFolder folder = null;
        try {
            IProject dbProject = AuditTrailDbManager.getDbProject(false);
            if (dbProject != null && dbProject.exists() && (folder = dbProject.getFolder(dbName)) != null && !folder.exists()) {
                folder = null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return folder;
    }

    public static List<IFolder> listDbs() {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        try {
            IProject dbProject = AuditTrailDbManager.getDbProject(false);
            if (dbProject != null && dbProject.exists()) {
                dbProject.refreshLocal(2, null);
                IResource[] members = dbProject.members();
                if (members != null) {
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IFolder && members[i].exists()) {
                            result.add((IFolder)members[i]);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFolder createDb(String dbName) throws AuditTrailManagementException {
        if (AuditTrailDbManager.findDb(dbName) != null) {
            return null;
        }
        IFolder dbFolder = null;
        try {
            IProject dbProject = AuditTrailDbManager.getDbProject(true);
            if (dbProject != null && (dbFolder = dbProject.getFolder(dbName)) != null && !dbFolder.exists()) {
                dbFolder.create(false, true, null);
                IPath dbLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(dbFolder.getFullPath());
                AuditTrailDbManager.createDbSystem(dbLocation.toFile());
                AuditTrailDbManager.initializeAuditTrailDb(dbLocation.toFile(), DEFAULT_AUDIT_TRAIL_NAME, DEFAULT_AUDIT_TRAIL_NAME);
                dbFolder.refreshLocal(2, null);
                AuditTrailActivator.instance().notifyDbListeners(dbFolder, 0);
            }
        }
        catch (CoreException ce) {
            throw new AuditTrailManagementException(Messages.FailedCreateDB, ce);
        }
        return dbFolder;
    }

    public static void resetDb(String dbName) throws AuditTrailManagementException {
        IFolder dbFolder = AuditTrailDbManager.findDb(dbName);
        if (dbFolder != null) {
            try {
                dbFolder.refreshLocal(2, null);
                IPath dbLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(dbFolder.getFullPath());
                AuditTrailDbManager.resetAuditTrailDb(dbLocation.toFile(), DEFAULT_AUDIT_TRAIL_NAME, DEFAULT_AUDIT_TRAIL_NAME);
                dbFolder.refreshLocal(2, null);
                AuditTrailActivator.instance().notifyDbListeners(dbFolder, 1);
            }
            catch (AuditTrailManagementException atme) {
                throw atme;
            }
            catch (CoreException ce) {
                throw new AuditTrailManagementException(Messages.FailedDeleteDB, ce);
            }
            catch (PublicException pe) {
                throw new AuditTrailManagementException(Messages.FailedResetDB, pe);
            }
        }
    }

    public static void deleteDb(String dbName) throws AuditTrailManagementException {
        IFolder dbFolder = AuditTrailDbManager.findDb(dbName);
        if (dbFolder != null) {
            try {
                dbFolder.refreshLocal(2, null);
                IPath dbLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(dbFolder.getFullPath());
                AuditTrailDbManager.cleanAuditTrailDb(dbLocation.toFile(), DEFAULT_AUDIT_TRAIL_NAME, DEFAULT_AUDIT_TRAIL_NAME);
                dbFolder.refreshLocal(2, null);
                dbFolder.delete(false, null);
                dbFolder.refreshLocal(2, null);
                AuditTrailActivator.instance().notifyDbListeners(dbFolder, 2);
            }
            catch (CoreException ce) {
                throw new AuditTrailManagementException(Messages.FailedDeleteDB, ce);
            }
        }
    }

    public static IProject getDbProject(boolean create) throws CoreException {
        IProject project = null;
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Infinity Audit Trails");
        if (project != null && !project.exists()) {
            if (create) {
                project.create(null);
            } else {
                project = null;
            }
        }
        if (project != null && !project.isOpen()) {
            project.open(128, null);
        }
        return project;
    }

    public static void initializeAuditTrailDb(File dbSystemHome, String dbName, final String schemaName) throws AuditTrailManagementException {
        try {
            new EmbeddedDerbyTemplate(new SqlTemplate(){

                @Override
                protected void executeSql(Statement stmt) throws SQLException {
                    stmt.execute("CREATE SCHEMA " + schemaName);
                }
            }).performOperation(dbSystemHome, dbName, schemaName, true);
            new EmbeddedDerbySessionTemplate(){

                @Override
                protected Object performDbOperation(Session session) throws SQLException {
                    SchemaHelper.createSchema((Session)session);
                    return null;
                }
            }.performOperation(dbSystemHome, dbName, schemaName);
        }
        catch (PublicException pe) {
            throw new AuditTrailManagementException(Messages.FailedInitDB, pe);
        }
    }

    public static void cleanAuditTrailDb(File dbSystemHome, String dbName, final String schemaName) throws AuditTrailManagementException {
        try {
            new EmbeddedDerbySessionTemplate(){

                @Override
                protected Object performDbOperation(Session session) throws SQLException {
                    SchemaHelper.dropSchema((Session)session, (String)"sysop");
                    return null;
                }
            }.performOperation(dbSystemHome, dbName, schemaName);
            new EmbeddedDerbyTemplate(new SqlTemplate(){

                @Override
                protected void executeSql(Statement stmt) throws SQLException {
                    stmt.execute("DROP SCHEMA " + schemaName + " RESTRICT");
                }
            }).performOperation(dbSystemHome, dbName, schemaName, true);
        }
        catch (PublicException pe) {
            throw new AuditTrailManagementException(Messages.FailedCleanDB, pe);
        }
    }

    public static void resetAuditTrailDb(File dbSystemHome, String dbName, String schemaName) throws AuditTrailManagementException {
        AuditTrailDbManager.cleanAuditTrailDb(dbSystemHome, dbName, schemaName);
        AuditTrailDbManager.initializeAuditTrailDb(dbSystemHome, dbName, schemaName);
    }

    public static void createDbSystem(File dbSystemHome) {
        try {
            Properties dbProps = new Properties();
            dbProps.put("derby.drda.startNetworkServer", Boolean.TRUE.toString());
            dbProps.put("derby.drda.logConnections", Boolean.TRUE.toString());
            DerbyDbActivator.getDefault().startDbms(dbSystemHome, 0, dbProps);
        }
        finally {
            try {
                DerbyDbActivator.getDefault().stopDbms();
            }
            catch (Exception stopException) {
                stopException.printStackTrace();
            }
        }
    }
}

