/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.modeling.common.ui.jface.CarnotUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class IconWithOverlays
extends CompositeImageDescriptor {
    public int defaultPosition = 2;
    public static int OVR_NONE = 0;
    public static int OVR_WARNINGS = 1;
    public static int OVR_ERRORS = 2;
    public static int OVR_LINK = 4;
    public static int OVR_REF = 8;
    public static int OVR_IF = 16;
    public static int OVR_PRIVATE = 32;
    private final ImageData baseIconData;
    private final ImageData overlayData;

    public IconWithOverlays(String baseIconLocator, int overlayMask) {
        this(CarnotUiPlugin.getDefault().getImageManager().getImageDescriptor(baseIconLocator), overlayMask);
    }

    public IconWithOverlays(ImageDescriptor baseIconDescriptor, int overlayMask) {
        this.baseIconData = baseIconDescriptor.getImageData();
        this.overlayData = CarnotUiPlugin.getDefault().getImageManager().getImage(this.getOverlayPath(overlayMask)).getImageData();
    }

    public IconWithOverlays(Image baseIcon, int overlayMask) {
        this.baseIconData = baseIcon.getImageData();
        this.overlayData = CarnotUiPlugin.getDefault().getImageManager().getImage(this.getOverlayPath(overlayMask)).getImageData();
    }

    public IconWithOverlays(Image baseIcon, Image overlay, int position) {
        this.baseIconData = baseIcon.getImageData();
        this.overlayData = overlay.getImageData();
        this.defaultPosition = position;
    }

    private String getOverlayPath(int overlayMask) {
        if ((overlayMask & OVR_REF) != 0) {
            return "icons/full/ovr16/ref_co.gif";
        }
        if ((overlayMask & OVR_IF) != 0) {
            return "icons/full/ovr16/interface_tsk.gif";
        }
        if ((overlayMask & OVR_PRIVATE) != 0) {
            return "icons/full/ovr16/owned_ovr.gif";
        }
        if ((overlayMask & OVR_LINK) != 0) {
            return "icons/full/ovr16/link_co.gif";
        }
        if ((overlayMask & OVR_ERRORS) != 0) {
            return "icons/full/ovr16/error_co.gif";
        }
        return "icons/full/ovr16/warning_co.gif";
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseIconData, 0, 0);
        if (this.overlayData != null) {
            switch (this.defaultPosition) {
                case 0: {
                    this.drawImage(this.overlayData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(this.overlayData, this.baseIconData.width - this.overlayData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(this.overlayData, 0, this.baseIconData.height - this.overlayData.height);
                    break;
                }
                case 3: {
                    this.drawImage(this.overlayData, this.baseIconData.width - this.overlayData.width, this.baseIconData.height - this.overlayData.height);
                }
            }
        }
    }

    protected Point getSize() {
        return new Point(this.baseIconData.width, this.baseIconData.height);
    }
}

