/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.widgets;

import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.CarnotUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LabelWithStatus
extends Composite {
    private final Label label = new Label((Composite)this, 0);
    private final Label icon;
    private IQuickValidationStatus status;

    public LabelWithStatus(Composite parent, String text) {
        this(parent, text, 0);
    }

    public LabelWithStatus(Composite parent, String text, int style) {
        super(parent, 0);
        this.label.setText(text);
        this.icon = new Label((Composite)this, 0);
        boolean alignRight = (style & 0x20000) != 0;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        this.setLayout((Layout)layout);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, alignRight, false));
        GridData iconLayout = new GridData(alignRight ? 131072 : 16384, 0x1000000, false, false);
        iconLayout.widthHint = 8;
        iconLayout.heightHint = 8;
        this.icon.setLayoutData((Object)iconLayout);
        this.setValidationStatus(IQuickValidationStatus.OK);
    }

    public String getText() {
        this.checkWidget();
        return this.label.getText();
    }

    public void setText(String text) {
        this.checkWidget();
        this.label.setText(text);
    }

    public IQuickValidationStatus getValidationStatus() {
        return this.status;
    }

    public void setValidationStatus(IQuickValidationStatus status) {
        IQuickValidationStatus iQuickValidationStatus = this.status = status != null ? status : IQuickValidationStatus.OK;
        Object img = status.hasErrors() ? CarnotUiPlugin.getDefault().getImageManager().getImage("icons/full/ovr16/error_co.gif") : (status.hasWarnings() ? CarnotUiPlugin.getDefault().getImageManager().getImage("icons/full/ovr16/warning_co.gif") : null);
        if (!this.icon.isDisposed() && img != this.icon.getImage()) {
            this.icon.setImage(img);
            this.icon.redraw();
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void dispose() {
        if (!this.icon.isDisposed()) {
            this.icon.dispose();
        }
        if (!this.label.isDisposed()) {
            this.label.dispose();
        }
        super.dispose();
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.label.setFocus();
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (!this.label.isDisposed()) {
            this.label.setToolTipText(string);
        }
        if (!this.icon.isDisposed()) {
            this.icon.setToolTipText(string);
        }
    }
}

