/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.preferences;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DrawingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private LabeledText transitionConditionLength;
    private Button chkHorizontalModeling;
    private Button chkVerticalModeling;
    private Button chkClassicModeOn;
    private Button chkClassicModeOff;
    private Button radioOneSymbolToGrid;
    private Button radioAllSymbolsToGrid;
    private Button radioPromptGrid;
    private Button chkViewForkOnTraversal;
    private Button chkEnableSnapGrid;
    private LabeledText snapGridPixel;
    private LabeledText visibleGridFactor;
    private Button[] splitButtons;
    private Button[] joinButtons;
    private ModifyListener snapGridListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.snapGridPixel.getText().getText()) && !DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.visibleGridFactor.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.snapGridPixel.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.visibleGridFactor.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else if (!DrawingPreferencePage.this.validateTransitionConditionSize(DrawingPreferencePage.this.transitionConditionLength.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_TransitionConditionValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else {
                DrawingPreferencePage.this.setValid(true);
                DrawingPreferencePage.this.setErrorMessage(null);
            }
        }
    };

    public DrawingPreferencePage() {
    }

    public DrawingPreferencePage(String title) {
        super(title);
    }

    public DrawingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private boolean validateTransitionConditionSize(String input) {
        boolean valid = true;
        Pattern pattern = Pattern.compile("^\\d+$");
        if (StringUtils.isEmpty((String)input)) {
            valid = false;
        } else if (input.length() > 4) {
            valid = false;
        } else {
            Matcher pixelMatcher = pattern.matcher(input);
            if (!pixelMatcher.matches()) {
                valid = false;
            } else {
                int value = Integer.parseInt(input);
                if (value <= 0 || value > 1000) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean validateSnapGridValues(String input) {
        boolean valid = true;
        Pattern pattern = Pattern.compile("^\\d+$");
        if (StringUtils.isEmpty((String)input)) {
            valid = false;
        } else if (input.length() > 2) {
            valid = false;
        } else {
            Matcher pixelMatcher = pattern.matcher(input);
            if (!pixelMatcher.matches()) {
                valid = false;
            } else {
                int value = Integer.parseInt(input);
                if (value <= 0) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    protected Control createContents(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        this.transitionConditionLength = FormBuilder.createLabeledText((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_VisibleTransitionConditionLength);
        this.chkViewForkOnTraversal = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_ViewForkOnTraversalLabel, (int)3);
        this.chkEnableSnapGrid = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_EnableSnapToGridLabel, (int)3);
        Group groupSnapGrid = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_SnapGridLabel, (int)2, (int)3);
        groupSnapGrid.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.snapGridPixel = FormBuilder.createLabeledText((Composite)groupSnapGrid, (String)UI_Messages.WorkbenchPreferencePage_SnapGridPixelLabel);
        this.visibleGridFactor = FormBuilder.createLabeledText((Composite)groupSnapGrid, (String)UI_Messages.WorkbenchPreferencePage_VisibleGridFactorLabel);
        Group group = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_ModelingDirectionLabel, (int)3, (int)3);
        group.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkVerticalModeling = FormBuilder.createRadioButton((Composite)group, (String)UI_Messages.WorkbenchPreferencePage_VerticalDirection);
        this.chkHorizontalModeling = FormBuilder.createRadioButton((Composite)group, (String)UI_Messages.WorkbenchPreferencePage_HorizontalDirection);
        Button dummyRadioButtonForAligning = FormBuilder.createRadioButton((Composite)group, (String)"ignore me");
        dummyRadioButtonForAligning.setEnabled(false);
        dummyRadioButtonForAligning.setVisible(false);
        Group groupClassicMode = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_DefaultDiagramMode, (int)3, (int)3);
        groupClassicMode.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkClassicModeOn = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)UI_Messages.WorkbenchPreferencePage_DiagramMode_On);
        this.chkClassicModeOff = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)UI_Messages.WorkbenchPreferencePage_DiagramMode_Off);
        Button dummyRadioButtonForAligningVintage = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)"ignore me");
        dummyRadioButtonForAligningVintage.setEnabled(false);
        dummyRadioButtonForAligningVintage.setVisible(false);
        Group groupDistributeOption = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_AutoDistribute, (int)3, (int)3);
        groupDistributeOption.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioOneSymbolToGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_SnapLastSymbol);
        this.radioAllSymbolsToGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_SnapAllSymbols);
        this.radioPromptGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_Prompt);
        this.splitButtons = this.createJoinSplitButtons(panel, FlowControlType.SPLIT_LITERAL);
        this.joinButtons = this.createJoinSplitButtons(panel, FlowControlType.JOIN_LITERAL);
        this.updateCheckbox();
        this.updateSplitJoin();
        this.updateAutoDistributeGroup();
        return panel;
    }

    private Button[] createJoinSplitButtons(Composite panel, FlowControlType flow) {
        Button[] buttons = new Button[JoinSplitType.values().length];
        Group group = FormBuilder.createGroup((Composite)panel, (String)MessageFormat.format(UI_Messages.LB_DefaultJoinSplitType, BpmUiActivator.i18n(flow)), (int)JoinSplitType.values().length, (int)3);
        group.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        int i = 0;
        JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
        int n = joinSplitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JoinSplitType type = joinSplitTypeArray[n2];
            if (type != JoinSplitType.NONE_LITERAL) {
                buttons[i++] = FormBuilder.createRadioButton((Composite)group, (String)BpmUiActivator.i18n(type));
            }
            ++n2;
        }
        buttons[i] = FormBuilder.createRadioButton((Composite)group, (String)UI_Messages.LB_Prompt);
        return buttons;
    }

    private void updateSplitJoin() {
        this.updateJoinSplitButtons(this.splitButtons, FlowControlType.SPLIT_LITERAL);
        this.updateJoinSplitButtons(this.joinButtons, FlowControlType.JOIN_LITERAL);
    }

    private void updateJoinSplitButtons(Button[] buttons, FlowControlType flow) {
        int i = 0;
        JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
        int n = joinSplitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JoinSplitType type = joinSplitTypeArray[n2];
            if (type != JoinSplitType.NONE_LITERAL) {
                buttons[i++].setSelection(PlatformUI.getPreferenceStore().getBoolean(this.getFlowPreferencesKey(flow, type)));
            }
            ++n2;
        }
        buttons[i].setSelection(PlatformUI.getPreferenceStore().getBoolean(this.getFlowPreferencesKey(flow)));
    }

    private void updateAutoDistributeGroup() {
        this.radioOneSymbolToGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureoneSymbol"));
        this.radioAllSymbolsToGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureallSymbols"));
        this.radioPromptGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureprompt"));
    }

    private void updateCheckbox() {
        this.chkViewForkOnTraversal.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode"));
        this.transitionConditionLength.getText().setText(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.transitionConditionLength"));
        this.transitionConditionLength.getText().addModifyListener(this.snapGridListener);
        this.chkEnableSnapGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.snapGridMode"));
        this.snapGridPixel.getText().setText(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel"));
        this.visibleGridFactor.getText().setText(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor"));
        this.snapGridPixel.getText().addModifyListener(this.snapGridListener);
        this.visibleGridFactor.getText().addModifyListener(this.snapGridListener);
        String direction = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection");
        this.chkVerticalModeling.setSelection(OrientationType.VERTICAL_LITERAL.toString().equals(direction));
        this.chkHorizontalModeling.setSelection(OrientationType.HORIZONTAL_LITERAL.toString().equals(direction));
        boolean classicMode = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode");
        this.chkClassicModeOn.setSelection(classicMode);
        this.chkClassicModeOff.setSelection(!classicMode);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode", this.chkViewForkOnTraversal.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.transitionConditionLength", this.transitionConditionLength.getText().getText());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.snapGridMode", this.chkEnableSnapGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel", this.snapGridPixel.getText().getText());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor", this.visibleGridFactor.getText().getText());
        String direction = "Vertical";
        if (this.chkVerticalModeling.getSelection()) {
            direction = OrientationType.VERTICAL_LITERAL.toString();
        } else if (this.chkHorizontalModeling.getSelection()) {
            direction = OrientationType.HORIZONTAL_LITERAL.toString();
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.modelingDirection", direction);
        boolean classicMode = true;
        if (this.chkClassicModeOn.getSelection()) {
            classicMode = true;
        } else if (this.chkClassicModeOff.getSelection()) {
            classicMode = false;
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.classicMode", classicMode);
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureoneSymbol", this.radioOneSymbolToGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureallSymbols", this.radioAllSymbolsToGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureprompt", this.radioPromptGrid.getSelection());
        this.saveSplitJoin();
        return true;
    }

    private void saveSplitJoin() {
        this.saveJoinSplit(this.splitButtons, FlowControlType.SPLIT_LITERAL);
        this.saveJoinSplit(this.joinButtons, FlowControlType.JOIN_LITERAL);
    }

    private void saveJoinSplit(Button[] buttons, FlowControlType flow) {
        int i = 0;
        JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
        int n = joinSplitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JoinSplitType type = joinSplitTypeArray[n2];
            if (type != JoinSplitType.NONE_LITERAL) {
                PlatformUI.getPreferenceStore().setValue(this.getFlowPreferencesKey(flow, type), buttons[i++].getSelection());
            }
            ++n2;
        }
        PlatformUI.getPreferenceStore().setValue(this.getFlowPreferencesKey(flow), buttons[i].getSelection());
    }

    private String getFlowPreferencesKey(FlowControlType flow) {
        return "org.eclipse.stardust.modeling.common.projectnature" + flow.getLiteral() + "Prompt";
    }

    private String getFlowPreferencesKey(FlowControlType flow, JoinSplitType type) {
        return "org.eclipse.stardust.modeling.common.projectnature" + flow.getLiteral() + type.getLiteral();
    }

    protected void performDefaults() {
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.transitionConditionLength");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.modelingDirection");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.classicMode");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureoneSymbol");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureallSymbols");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureprompt");
        this.updateCheckbox();
        this.updateSplitJoin();
        this.updateAutoDistributeGroup();
    }
}

