/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.RoleSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.SelectionPopup;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;

public class CreateOrganizationHierarchyAction
extends SelectionAction {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private WorkflowModelEditor editor;
    private EditPart targetEP;
    private List participantList;
    private int downValue = 100;
    private int rightValue = 100;

    public CreateOrganizationHierarchyAction(IWorkbenchPart part) {
        super(part);
        this.editor = (WorkflowModelEditor)part;
        this.setText(Diagram_Messages.LB_CreateOrganizationHierarchy);
        this.setToolTipText(Diagram_Messages.LB_CreateOrganizationHierarchy);
        this.setId("org.eclipse.stardust.modeling.core.createOrganizationHierarchy");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/organization.gif"));
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        if (selection.size() != 1) {
            return false;
        }
        Object selected = this.getSelectedObjects().get(0);
        if (selected != null && (selected instanceof DiagramEditPart || selected instanceof DiagramRootEditPart)) {
            if (GenericUtils.getTargetEditPart(this.editor) == null) {
                return false;
            }
        } else {
            return false;
        }
        ModelType model = (ModelType)this.editor.getModel();
        return model.getOrganization().size() > 0;
    }

    public void run() {
        ModelType model = (ModelType)this.editor.getModel();
        OrganizationType organization = null;
        EList organizations = model.getOrganization();
        if (organizations.size() > 1) {
            SelectionPopup popup = new SelectionPopup(this.editor.getSite().getShell());
            popup.setContentProvider((IContentProvider)new ArrayContentProvider());
            popup.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof OrganizationType) {
                        return DiagramPlugin.getImage(CreateOrganizationHierarchyAction.this.editor.getIconFactory().getIconFor((EObject)((OrganizationType)element)));
                    }
                    return super.getImage(element);
                }

                public String getText(Object element) {
                    if (element instanceof OrganizationType) {
                        return ((OrganizationType)element).getName();
                    }
                    return super.getText(element);
                }
            });
            popup.setInput((Object)organizations);
            organization = (OrganizationType)popup.open();
            if (organization == null) {
                return;
            }
        } else {
            organization = (OrganizationType)organizations.get(0);
        }
        this.participantList = new ArrayList();
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)this.editor.getCurrentPage();
        Point location = diagramEditorPage.getMouseLocation().getCopy();
        CompoundCommand compoundCommand = new CompoundCommand();
        this.targetEP = GenericUtils.getTargetEditPart(this.editor);
        this.drawOrganizationHierarchy(organization, location, compoundCommand);
        Command resizeCmd = this.resizeSymbols(compoundCommand);
        Command connectionCmd = this.drawOrganizationHierarchyConnections(compoundCommand, organization);
        compoundCommand = (CompoundCommand)compoundCommand.chain(resizeCmd);
        compoundCommand = (CompoundCommand)compoundCommand.chain(connectionCmd);
        if (this.targetEP instanceof AbstractSwimlaneEditPart) {
            compoundCommand.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)CreateOrganizationHierarchyAction.this.targetEP);
                }
            });
            compoundCommand.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    return PoolLaneUtils.reorderSiblings(CreateOrganizationHierarchyAction.this.targetEP, null);
                }
            });
        }
        this.execute((Command)compoundCommand);
        this.targetEP.refresh();
    }

    private void drawOrganizationHierarchy(OrganizationType organization, Point location, CompoundCommand compoundCommand) {
        RoleType teamLead;
        Point useLocation = location.getCopy();
        if (!this.participantList.contains(organization)) {
            this.participantList.add(organization);
            Command cmd = this.createSymbol((IModelParticipant)organization, useLocation);
            compoundCommand.add(cmd);
            useLocation.y += this.downValue;
        }
        if ((teamLead = organization.getTeamLead()) != null && !this.participantList.contains(teamLead)) {
            this.participantList.add(teamLead);
            Command cmd = this.createSymbol((IModelParticipant)teamLead, useLocation);
            compoundCommand.add(cmd);
            useLocation.x += this.rightValue;
        }
        EList participants = organization.getParticipant();
        for (ParticipantType participant : participants) {
            IModelParticipant member = participant.getParticipant();
            if (member instanceof OrganizationType) {
                this.drawOrganizationHierarchy((OrganizationType)member, useLocation, compoundCommand);
                useLocation.x += this.rightValue;
                continue;
            }
            if (this.participantList.contains(member)) continue;
            this.participantList.add(member);
            Command cmd = this.createSymbol(member, useLocation);
            compoundCommand.add(cmd);
            useLocation.x += this.rightValue;
        }
    }

    private Command createSymbol(IModelParticipant element, Point location) {
        EClass eClass = null;
        eClass = element instanceof OrganizationType ? PKG.getOrganizationSymbolType() : (element instanceof ConditionalPerformerType ? PKG.getConditionalPerformerSymbolType() : PKG.getRoleSymbolType());
        IdFactory id = new IdFactory("Symbol", Diagram_Messages.BASENAME_Symbol, (IIdentifiableModelElement)element);
        CreateSymbolCommand cmd = new CreateSymbolCommand(0, id, eClass);
        cmd.setParent((EObject)this.targetEP.getModel());
        cmd.setLocation(new Rectangle(location.x, location.y, -1, -1));
        return cmd;
    }

    private Command resizeSymbols(final CompoundCommand cmd) {
        return new DelegatingCommand(){
            private Map elementToSymbol = new HashMap();

            private void collectSymbols() {
                for (Command child : cmd.getCommands()) {
                    if (!(child instanceof CreateSymbolCommand)) continue;
                    IModelParticipantSymbol symbol = (IModelParticipantSymbol)((CreateSymbolCommand)child).getModelElement();
                    IIdentifiableModelElement model = symbol.getModelElement();
                    this.elementToSymbol.put(model, symbol);
                }
            }

            @Override
            public Command createDelegate() {
                this.collectSymbols();
                CompoundCommand command = new CompoundCommand();
                this.resizeSymbols(command);
                return command;
            }

            private void resizeSymbols(CompoundCommand command) {
                for (Map.Entry entry : this.elementToSymbol.entrySet()) {
                    IModelParticipantSymbol symbol = (IModelParticipantSymbol)entry.getValue();
                    AbstractGraphicalEditPart editPart = (AbstractGraphicalEditPart)CreateOrganizationHierarchyAction.this.editor.findEditPart(symbol);
                    Dimension prefSize = editPart.getFigure().getPreferredSize();
                    Dimension size = SnapGridUtils.getSnapDimension(prefSize, (AbstractGraphicalEditPart)CreateOrganizationHierarchyAction.this.targetEP, 2, true);
                    boolean change = false;
                    if (size.height < prefSize.height) {
                        prefSize.height += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE;
                        change = true;
                    }
                    if (size.width < prefSize.width) {
                        prefSize.width += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE;
                        change = true;
                    }
                    if (change) {
                        size = SnapGridUtils.getSnapDimension(prefSize, (AbstractGraphicalEditPart)CreateOrganizationHierarchyAction.this.targetEP, 2, true);
                    }
                    Point newLocation = new Point(new Long(symbol.getXPos()).intValue() - size.width / 2, new Long(symbol.getYPos()).intValue() - size.height / 2);
                    Point setLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)CreateOrganizationHierarchyAction.this.targetEP, (AbstractNodeSymbolEditPart)editPart, null, size, newLocation);
                    if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)CreateOrganizationHierarchyAction.this.targetEP) == null) continue;
                    Rectangle rect = new Rectangle();
                    rect.setLocation(setLocation);
                    rect.setSize(size);
                    MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
                    moveCommand.setPart((INodeSymbol)symbol);
                    moveCommand.setBounds(rect);
                    command.add((Command)moveCommand);
                }
            }
        };
    }

    private Command drawOrganizationHierarchyConnections(final CompoundCommand cmd, final OrganizationType organization) {
        return new DelegatingCommand(){
            private Map elementToSymbol = new HashMap();

            private void collectSymbols() {
                for (Command child : cmd.getCommands()) {
                    if (!(child instanceof CreateSymbolCommand)) continue;
                    IModelParticipantSymbol symbol = (IModelParticipantSymbol)((CreateSymbolCommand)child).getModelElement();
                    IIdentifiableModelElement model = symbol.getModelElement();
                    this.elementToSymbol.put(model, symbol);
                }
            }

            @Override
            public Command createDelegate() {
                this.collectSymbols();
                CompoundCommand command = new CompoundCommand();
                this.drawOrganizationHierarchyConnection(organization, command);
                return command;
            }

            private void drawOrganizationHierarchyConnection(OrganizationType organization2, CompoundCommand command) {
                OrganizationSymbolType organizationSymbol = (OrganizationSymbolType)this.elementToSymbol.get(organization2);
                RoleType teamLead = organization2.getTeamLead();
                if (teamLead != null) {
                    RoleSymbolType roleSymbol = (RoleSymbolType)this.elementToSymbol.get(teamLead);
                    CreateConnectionSymbolCommand connectionCmd = new CreateConnectionSymbolCommand(null, PKG.getTeamLeadConnectionType());
                    connectionCmd.setParent((EObject)CreateOrganizationHierarchyAction.this.targetEP.getModel());
                    connectionCmd.setTargetSymbol((INodeSymbol)organizationSymbol);
                    connectionCmd.setSourceSymbol((INodeSymbol)roleSymbol);
                    command.add((Command)connectionCmd);
                }
                EList participants = organization2.getParticipant();
                for (ParticipantType participant : participants) {
                    CreateConnectionSymbolCommand connectionCmd;
                    IModelParticipant member = participant.getParticipant();
                    IModelParticipantSymbol participantSymbol = (IModelParticipantSymbol)this.elementToSymbol.get(member);
                    if (member instanceof OrganizationType) {
                        connectionCmd = new CreateConnectionSymbolCommand(null, PKG.getPartOfConnectionType());
                        connectionCmd.setParent((EObject)CreateOrganizationHierarchyAction.this.targetEP.getModel());
                        connectionCmd.setTargetSymbol((INodeSymbol)organizationSymbol);
                        connectionCmd.setSourceSymbol((INodeSymbol)participantSymbol);
                        command.add((Command)connectionCmd);
                        this.drawOrganizationHierarchyConnection((OrganizationType)member, command);
                        continue;
                    }
                    connectionCmd = new CreateConnectionSymbolCommand(null, PKG.getWorksForConnectionType());
                    connectionCmd.setParent((EObject)CreateOrganizationHierarchyAction.this.targetEP.getModel());
                    connectionCmd.setTargetSymbol((INodeSymbol)organizationSymbol);
                    connectionCmd.setSourceSymbol((INodeSymbol)participantSymbol);
                    command.add((Command)connectionCmd);
                }
            }
        };
    }
}

