/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.ExecutedByConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.PartOfConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PerformsConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TeamLeadConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.ViewableType;
import org.eclipse.stardust.model.xpdl.carnot.WorksForConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteGraphicalObjectCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.views.bookmark.WorkflowModelBookmarkView;
import org.eclipse.ui.PlatformUI;

public class DeleteAllCommandFactory {
    private static final CarnotWorkflowModelPackage cwm_pkg = CarnotWorkflowModelPackage.eINSTANCE;

    public static Command createDeleteAllCommand(TypeDeclarationType declaration) {
        CompoundCommand cmd = new CompoundCommand();
        ModelType model = ModelUtils.findContainingModel((EObject)declaration);
        EList applications = model.getApplication();
        ArrayList<AccessPointType> allApplicationAccessPoints = new ArrayList<AccessPointType>();
        for (ApplicationType application : applications) {
            EList accessPoints = application.getAccessPoint();
            for (AccessPointType accessPoint : accessPoints) {
                TypeDeclarationType accessPointDeclaration = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                if (accessPointDeclaration == null || !accessPointDeclaration.equals(declaration)) continue;
                allApplicationAccessPoints.add(accessPoint);
                AttributeType att = AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                if (att != null) {
                    cmd.add((Command)new DeleteValueCmd((EObject)att, (EStructuralFeature)cwm_pkg.getAttributeType_Reference()));
                }
                DeleteAllCommandFactory.addDeleteActivityReferences(cmd, (EObject)accessPoint);
                cmd.add((Command)new DeleteValueCmd((EObject)application, accessPoint, accessPoint.eContainingFeature()));
            }
        }
        cmd.add((Command)new DeleteValueCmd(declaration.eContainer(), declaration, (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationsType_TypeDeclaration()));
        return cmd;
    }

    private static void addDeleteActivityReferences(CompoundCommand cmd, EObject element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        EList processes = model.getProcessDefinition();
        for (ProcessDefinitionType process : processes) {
            EList activities = process.getActivity();
            for (ActivityType activity : activities) {
                ApplicationType application = activity.getApplication();
                EList dataMappings = activity.getDataMapping();
                for (DataMappingType dataMapping : dataMappings) {
                    DataType data = dataMapping.getData();
                    if (data != null && data.equals(element)) {
                        cmd.add((Command)new DeleteValueCmd((EObject)activity, dataMapping, (EStructuralFeature)cwm_pkg.getActivityType_DataMapping()));
                        continue;
                    }
                    if (!(element instanceof AccessPointType)) continue;
                    AccessPointType accessPoint = (AccessPointType)element;
                    String accessPointAttribute = dataMapping.getApplicationAccessPoint();
                    if (StringUtils.isEmpty((String)accessPointAttribute) || application == null || !application.equals(accessPoint.eContainer()) || !accessPoint.getId().equals(accessPointAttribute)) continue;
                    cmd.add((Command)new DeleteValueCmd((EObject)dataMapping, (EStructuralFeature)cwm_pkg.getDataMappingType_ApplicationPath()));
                    cmd.add((Command)new DeleteValueCmd((EObject)dataMapping, (EStructuralFeature)cwm_pkg.getDataMappingType_ApplicationAccessPoint()));
                }
            }
        }
    }

    public static Command createDeleteAllCommand(IModelElement model) {
        IModelElement root = DeleteAllCommandFactory.findRootElement(model);
        CompoundCommand cmd = new CompoundCommand();
        if (root instanceof IConnectionSymbol) {
            if (root instanceof DataMappingConnectionType) {
                DeleteAllCommandFactory.addDeleteDataMappings(cmd, (DataMappingConnectionType)root);
            } else if (root instanceof ExecutedByConnectionType) {
                DeleteAllCommandFactory.addDeleteExecutedBy(cmd, (ExecutedByConnectionType)root);
            } else if (root instanceof PerformsConnectionType) {
                DeleteAllCommandFactory.addDeletePerforms(cmd, (PerformsConnectionType)root);
            } else if (root instanceof WorksForConnectionType) {
                DeleteAllCommandFactory.addDeleteWorksFor(cmd, (WorksForConnectionType)root);
            } else if (root instanceof TeamLeadConnectionType) {
                DeleteAllCommandFactory.addDeleteTeamLead(cmd, (TeamLeadConnectionType)root);
            } else if (root instanceof PartOfConnectionType) {
                DeleteAllCommandFactory.addDeletePartOf(cmd, (PartOfConnectionType)root);
            }
        } else if (root != null) {
            DeleteAllCommandFactory.addDeleteModelElement(cmd, (EObject)root);
        }
        return cmd.unwrap();
    }

    private static void addDeleteModelElement(CompoundCommand cmd, EObject element) {
        DeleteAllCommandFactory.addDeleteSymbols(cmd, element);
        DeleteAllCommandFactory.addDeleteViewables(cmd, element);
        DeleteAllCommandFactory.fixReferences(cmd, element, element, new HashSet());
        if (element instanceof IModelParticipant) {
            DeleteAllCommandFactory.addDeleteParticipantAssociations(cmd, element);
        }
        if (element instanceof DataType) {
            DeleteAllCommandFactory.fixDataAttributeReferences(cmd, (DataType)element);
        }
        cmd.add((Command)new DeleteValueCmd(element.eContainer(), element, element.eContainingFeature()));
    }

    private static void fixDataAttributeReferences(CompoundCommand cmd, DataType data) {
        ArrayList actions = new ArrayList();
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        if (model == null) {
            return;
        }
        new HashMap();
        for (ProcessDefinitionType process : model.getProcessDefinition()) {
            Iterator iterator = process.getEventHandler().iterator();
            while (iterator.hasNext()) {
                DeleteAllCommandFactory.getActionTypes(actions, (EventHandlerType)iterator.next());
            }
            for (ActivityType activity : process.getActivity()) {
                ModelType modelType = ModelUtils.findContainingModel((EObject)process);
                GenericUtils.getWorkflowModelEditor(modelType);
                EList dataMappings = activity.getDataMapping();
                for (DataMappingType dataMapping : dataMappings) {
                    DataType dataMappingData = dataMapping.getData();
                    if (dataMappingData == null || !data.equals(dataMappingData)) continue;
                    cmd.add((Command)new DeleteValueCmd((EObject)dataMapping, (EStructuralFeature)cwm_pkg.getDataMappingType_Data()));
                    cmd.add((Command)new DeleteValueCmd((EObject)activity, dataMapping, (EStructuralFeature)cwm_pkg.getActivityType_DataMapping()));
                }
                Iterator iter2 = activity.getEventHandler().iterator();
                while (iter2.hasNext()) {
                    DeleteAllCommandFactory.getActionTypes(actions, (EventHandlerType)iter2.next());
                }
            }
        }
        for (AbstractEventAction action : actions) {
            if (!"mail".equals(action.getType().getId()) || !data.getId().equals(AttributeUtil.getAttributeValue((IExtensibleElement)action, (String)"carnot:engine:mailBodyData"))) continue;
            AttributeType att = AttributeUtil.getAttribute((IExtensibleElement)action, (String)"carnot:engine:mailBodyData");
            cmd.add((Command)new DeleteValueCmd(att.eContainer(), att, att.eContainingFeature()));
            AttributeType attDP = AttributeUtil.getAttribute((IExtensibleElement)action, (String)"carnot:engine:mailBodyDataPath");
            if (attDP == null) continue;
            cmd.add((Command)new DeleteValueCmd(attDP.eContainer(), attDP, attDP.eContainingFeature()));
        }
    }

    private static void getActionTypes(List actions, EventHandlerType eventHandler) {
        actions.addAll(eventHandler.getUnbindAction());
        actions.addAll(eventHandler.getBindAction());
        actions.addAll(eventHandler.getEventAction());
    }

    private static void addDeleteViewables(CompoundCommand cmd, EObject eObject) {
        ModelType model = ModelUtils.findContainingModel((EObject)eObject);
        if (model != null) {
            DeleteAllCommandFactory.deleteViewables(cmd, model.getView(), eObject);
        }
    }

    private static void addDeleteParticipantAssociations(CompoundCommand cmd, EObject element) {
        IModelParticipant participant = (IModelParticipant)element;
        EList associations = participant.getParticipantAssociations();
        int i = 0;
        while (i < associations.size()) {
            ParticipantType assoc = (ParticipantType)associations.get(i);
            OrganizationType organization = (OrganizationType)assoc.eContainer();
            cmd.add((Command)new DeleteValueCmd((EObject)organization, assoc, (EStructuralFeature)cwm_pkg.getOrganizationType_Participant()));
            ++i;
        }
    }

    private static void deleteViewables(CompoundCommand cmd, EList views, EObject eObject) {
        for (ViewType view : views) {
            ArrayList<ViewableType> deletedViewables = new ArrayList<ViewableType>();
            for (ViewableType viewable : view.getViewable()) {
                for (EObject childElement : ((IModelElement)eObject).eContents()) {
                    if (!viewable.getViewable().equals(childElement)) continue;
                    deletedViewables.add(viewable);
                }
                if (!viewable.getViewable().equals(eObject)) continue;
                deletedViewables.add(viewable);
            }
            for (ViewableType viewable : deletedViewables) {
                cmd.add((Command)new DeleteValueCmd(viewable.eContainer(), viewable, viewable.eContainingFeature()){

                    private void updateViewer() {
                        WorkflowModelBookmarkView viewPart = (WorkflowModelBookmarkView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.stardust.modeling.core.views.bookmark");
                        if (viewPart != null) {
                            viewPart.updateViewer();
                        }
                    }

                    @Override
                    public void execute() {
                        super.execute();
                        this.updateViewer();
                    }

                    @Override
                    public void redo() {
                        super.redo();
                        this.updateViewer();
                    }

                    @Override
                    public void undo() {
                        super.undo();
                        this.updateViewer();
                    }
                });
            }
            if (view.getView().size() <= 0) continue;
            DeleteAllCommandFactory.deleteViewables(cmd, view.getView(), eObject);
        }
    }

    private static void addDeleteSymbols(CompoundCommand cmd, EObject element) {
        block13: {
            EList activitySymbols;
            block12: {
                Object symbol;
                if (!(element instanceof IIdentifiableModelElement)) break block12;
                Object tmpSymbols = null;
                ArrayList symbols = new ArrayList();
                new HashMap();
                try {
                    tmpSymbols = ((IIdentifiableModelElement)element).getSymbols();
                }
                catch (Exception exception) {
                    tmpSymbols = Collections.EMPTY_LIST;
                }
                int i = 0;
                while (i < tmpSymbols.size()) {
                    symbol = tmpSymbols.get(i);
                    symbols.add(symbol);
                    ++i;
                }
                i = 0;
                while (i < symbols.size()) {
                    symbol = symbols.get(i);
                    if (symbol instanceof INodeSymbol) {
                        DeleteAllCommandFactory.addDeleteConnections(cmd, (INodeSymbol)symbol, ((INodeSymbol)symbol).getInConnectionFeatures());
                        DeleteAllCommandFactory.addDeleteConnections(cmd, (INodeSymbol)symbol, ((INodeSymbol)symbol).getOutConnectionFeatures());
                        if (((INodeSymbol)symbol).eContainer() instanceof GroupSymbolType) {
                            DeleteAllCommandFactory.moveGroupSymbols(cmd, (GroupSymbolType)((INodeSymbol)symbol).eContainer(), (INodeSymbol)symbol);
                        }
                        cmd.add((Command)new DeleteGraphicalObjectCmd((IGraphicalObject)((INodeSymbol)symbol)));
                    } else {
                        DeleteAllCommandFactory.addDeleteConnection(cmd, symbol);
                    }
                    ++i;
                }
                break block13;
            }
            if (!(element instanceof LaneSymbol) || (activitySymbols = ((LaneSymbol)element).getActivitySymbol()).isEmpty()) break block13;
            ArrayList gatewayTransitions = new ArrayList();
            for (ActivitySymbolType activitySymbol : activitySymbols) {
                EList gatewaySymbols = activitySymbol.getGatewaySymbols();
                if (gatewaySymbols.isEmpty()) continue;
                for (GatewaySymbol gatewaySymbol : gatewaySymbols) {
                    cmd.add((Command)new DeleteGraphicalObjectCmd((IGraphicalObject)gatewaySymbol));
                    if (!gatewaySymbol.getInTransitions().isEmpty()) {
                        gatewayTransitions.addAll(gatewaySymbol.getInTransitions());
                    }
                    if (gatewaySymbol.getOutTransitions().isEmpty()) continue;
                    gatewayTransitions.addAll(gatewaySymbol.getOutTransitions());
                }
            }
            if (!gatewayTransitions.isEmpty()) {
                for (TransitionConnectionType transition : gatewayTransitions) {
                    DeleteAllCommandFactory.addDeleteConnection(cmd, transition);
                }
            }
        }
    }

    private static void moveGroupSymbols(CompoundCommand cmd, GroupSymbolType groupSymbol, INodeSymbol symbol) {
        INodeSymbol nodeSymbol;
        EList gateways = new ArrayList();
        if (symbol instanceof ActivitySymbolType) {
            gateways = ((ActivitySymbolType)symbol).getGatewaySymbols();
        }
        long xPos = -1L;
        long yPos = -1L;
        FeatureMap.ValueListIterator iter = groupSymbol.getNodes().valueListIterator();
        while (iter.hasNext()) {
            nodeSymbol = (INodeSymbol)iter.next();
            if (nodeSymbol.equals(symbol) || gateways.contains(nodeSymbol)) continue;
            if (xPos == -1L || nodeSymbol.getXPos() < xPos) {
                xPos = nodeSymbol.getXPos();
            }
            if (yPos != -1L && nodeSymbol.getYPos() >= yPos) continue;
            yPos = nodeSymbol.getYPos();
        }
        if (xPos != 0L || yPos != 0L) {
            iter = groupSymbol.getNodes().valueListIterator();
            while (iter.hasNext()) {
                nodeSymbol = (INodeSymbol)iter.next();
                if (nodeSymbol.equals(symbol) || gateways.contains(nodeSymbol)) continue;
                cmd.add((Command)new SetValueCmd((EObject)nodeSymbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(nodeSymbol.getXPos() - xPos)));
                cmd.add((Command)new SetValueCmd((EObject)nodeSymbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(nodeSymbol.getYPos() - yPos)));
            }
            cmd.add((Command)new SetValueCmd((EObject)groupSymbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(groupSymbol.getXPos() + xPos)));
            cmd.add((Command)new SetValueCmd((EObject)groupSymbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(groupSymbol.getYPos() + yPos)));
        }
        if (groupSymbol.getNodes().size() == 1) {
            cmd.add((Command)new DeleteGraphicalObjectCmd((IGraphicalObject)groupSymbol));
        }
    }

    private static void addDeleteConnections(CompoundCommand cmd, INodeSymbol symbol, List connectionFeatures) {
        int i = 0;
        while (i < connectionFeatures.size()) {
            EStructuralFeature feature = (EStructuralFeature)connectionFeatures.get(i);
            Object connection = symbol.eGet(feature);
            if (connection instanceof List) {
                List connectionList = (List)connection;
                int j = 0;
                while (j < connectionList.size()) {
                    connection = connectionList.get(j);
                    DeleteAllCommandFactory.addDeleteConnection(cmd, connection);
                    ++j;
                }
            } else {
                DeleteAllCommandFactory.addDeleteConnection(cmd, connection);
            }
            ++i;
        }
    }

    private static void addDeleteConnection(CompoundCommand cmd, Object symbol) {
        if (symbol instanceof IConnectionSymbol) {
            if (symbol instanceof TransitionConnectionType) {
                TransitionConnectionType transition = (TransitionConnectionType)symbol;
                if (transition.getTransition() != null) {
                    return;
                }
                if (transition.getSourceNode() instanceof GatewaySymbol && ((GatewaySymbol)transition.getSourceNode()).getActivitySymbol().equals(transition.getTargetNode())) {
                    cmd.add((Command)new DeleteGraphicalObjectCmd((IGraphicalObject)transition.getSourceNode()));
                } else if (transition.getTargetNode() instanceof GatewaySymbol && ((GatewaySymbol)transition.getTargetNode()).getActivitySymbol().equals(transition.getSourceNode())) {
                    cmd.add((Command)new DeleteGraphicalObjectCmd((IGraphicalObject)transition.getTargetNode()));
                }
            }
            cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)symbol));
        }
    }

    private static void fixReferences(CompoundCommand cmd, EObject element, EObject scope, Set visited) {
        if (!visited.contains(element)) {
            visited.add(element);
            EList references = element.eClass().getEAllReferences();
            int i = 0;
            while (i < references.size()) {
                EReference reference = (EReference)references.get(i);
                if (reference.isMany()) {
                    List list = (List)element.eGet((EStructuralFeature)reference);
                    int j = 0;
                    while (j < list.size()) {
                        Object childElement = list.get(j);
                        if (childElement instanceof ParticipantType) {
                            cmd.add((Command)new DeleteValueCmd(element, childElement, (EStructuralFeature)reference));
                        }
                        DeleteAllCommandFactory.fixReference(cmd, element, scope, childElement, reference, visited);
                        ++j;
                    }
                } else {
                    DeleteAllCommandFactory.fixReference(cmd, element, scope, element.eGet((EStructuralFeature)reference), reference, visited);
                }
                ++i;
            }
        }
    }

    private static void fixReference(CompoundCommand cmd, EObject element, EObject scope, Object value, EReference reference, Set visited) {
        if (value != null && value instanceof EObject) {
            if (DeleteAllCommandFactory.isInScope((EObject)value, scope)) {
                DeleteAllCommandFactory.fixReferences(cmd, (EObject)value, scope, visited);
            } else {
                if (value instanceof TransitionType && !(scope instanceof ISwimlaneSymbol) && !(scope instanceof DiagramType)) {
                    EList connections = ((TransitionType)value).getSymbols();
                    int i = 0;
                    while (i < connections.size()) {
                        TransitionConnectionType symbol = (TransitionConnectionType)connections.get(i);
                        cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)symbol));
                        ++i;
                    }
                    DeleteAllCommandFactory.addDeleteModelElement(cmd, (EObject)value);
                }
                if (value instanceof IConnectionSymbol) {
                    cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)value));
                } else {
                    cmd.add((Command)new DeleteValueCmd(element, value, (EStructuralFeature)reference));
                }
            }
        }
    }

    private static boolean isInScope(EObject value, EObject scope) {
        while (!scope.equals(value)) {
            if (value instanceof ModelType || value.eContainer() == null) break;
            value = value.eContainer();
        }
        return scope.equals(value);
    }

    private static void addDeleteDataMappings(CompoundCommand cmd, DataMappingConnectionType dataMappingConnection) {
        ActivitySymbolType activitySymbol = dataMappingConnection.getActivitySymbol();
        DataSymbolType dataSymbol = dataMappingConnection.getDataSymbol();
        if (dataSymbol != null && activitySymbol != null) {
            DataType data = dataSymbol.getData();
            ActivityType activity = activitySymbol.getActivity();
            DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)activity, (EStructuralFeature)cwm_pkg.getActivitySymbolType_DataMappings(), (IIdentifiableModelElement)data, (EStructuralFeature)cwm_pkg.getDataMappingConnectionType_DataSymbol());
            EList dataMappingsList = activity.getDataMapping();
            int i = 0;
            while (i < dataMappingsList.size()) {
                DataMappingType dataMapping = (DataMappingType)dataMappingsList.get(i);
                if (data.equals(dataMapping.getData())) {
                    cmd.add((Command)new DeleteValueCmd((EObject)dataMapping, (EStructuralFeature)cwm_pkg.getDataMappingType_Data()));
                    cmd.add((Command)new DeleteValueCmd((EObject)activity, dataMapping, (EStructuralFeature)cwm_pkg.getActivityType_DataMapping()));
                }
                ++i;
            }
        }
    }

    private static void addDeleteWorksFor(CompoundCommand cmd, WorksForConnectionType worksForConnection) {
        RoleType role = worksForConnection.getParticipantSymbol().getRole();
        OrganizationType organization = worksForConnection.getOrganizationSymbol().getOrganization();
        DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)role, (EStructuralFeature)cwm_pkg.getRoleSymbolType_OrganizationMemberships(), (IIdentifiableModelElement)organization, (EStructuralFeature)cwm_pkg.getWorksForConnectionType_OrganizationSymbol());
        DeleteAllCommandFactory.addRemoveParticipant(organization, (IModelParticipant)role, cmd);
    }

    private static void addDeleteTeamLead(CompoundCommand cmd, TeamLeadConnectionType teamLeadConnection) {
        RoleType role = teamLeadConnection.getTeamLeadSymbol().getRole();
        OrganizationType organization = teamLeadConnection.getTeamSymbol().getOrganization();
        DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)role, (EStructuralFeature)cwm_pkg.getRoleSymbolType_Teams(), (IIdentifiableModelElement)organization, (EStructuralFeature)cwm_pkg.getTeamLeadConnectionType_TeamSymbol());
        cmd.add((Command)new DeleteValueCmd((EObject)organization, role, (EStructuralFeature)cwm_pkg.getOrganizationType_TeamLead()));
    }

    private static void addDeletePartOf(CompoundCommand cmd, PartOfConnectionType partOfConnection) {
        OrganizationType suborganization = partOfConnection.getSuborganizationSymbol().getOrganization();
        OrganizationType organization = partOfConnection.getOrganizationSymbol().getOrganization();
        DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)suborganization, (EStructuralFeature)cwm_pkg.getOrganizationSymbolType_SuperOrganizations(), (IIdentifiableModelElement)organization, (EStructuralFeature)cwm_pkg.getPartOfConnectionType_OrganizationSymbol());
        DeleteAllCommandFactory.addRemoveParticipant(organization, (IModelParticipant)suborganization, cmd);
    }

    private static void addRemoveParticipant(OrganizationType organization, IModelParticipant modelParticipant, CompoundCommand cmd) {
        EList participantsList = organization.getParticipant();
        int i = 0;
        while (i < participantsList.size()) {
            ParticipantType participant = (ParticipantType)participantsList.get(i);
            if (modelParticipant.equals(participant.getParticipant())) {
                cmd.add((Command)new DeleteValueCmd((EObject)organization, participant, (EStructuralFeature)cwm_pkg.getOrganizationType_Participant()));
            }
            ++i;
        }
    }

    private static void addDeletePerforms(CompoundCommand cmd, PerformsConnectionType performsConnection) {
        ActivityType activity = performsConnection.getActivitySymbol().getActivity();
        DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)activity, (EStructuralFeature)cwm_pkg.getActivitySymbolType_PerformsConnections(), performsConnection.getParticipantSymbol().getModelElement(), (EStructuralFeature)cwm_pkg.getPerformsConnectionType_ParticipantSymbol());
        cmd.add((Command)new DeleteValueCmd((EObject)activity, (EStructuralFeature)cwm_pkg.getActivityType_Performer()));
    }

    private static void addDeleteExecutedBy(CompoundCommand cmd, ExecutedByConnectionType executedByConnection) {
        ActivityType activity = executedByConnection.getActivitySymbol().getActivity();
        DeleteAllCommandFactory.addDeleteConnections(cmd, (IIdentifiableModelElement)activity, (EStructuralFeature)cwm_pkg.getActivitySymbolType_ExecutedByConnections(), (IIdentifiableModelElement)executedByConnection.getApplicationSymbol().getApplication(), (EStructuralFeature)cwm_pkg.getExecutedByConnectionType_ApplicationSymbol());
        cmd.add((Command)new DeleteValueCmd((EObject)activity, (EStructuralFeature)cwm_pkg.getActivityType_Application()));
    }

    private static void addDeleteConnections(CompoundCommand cmd, IIdentifiableModelElement source, EStructuralFeature connectionsListFeature, IIdentifiableModelElement other, EStructuralFeature otherSymbolFeature) {
        EList symbolsList = source.getSymbols();
        int i = 0;
        while (i < symbolsList.size()) {
            IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)symbolsList.get(i);
            List connectionList = (List)symbol.eGet(connectionsListFeature);
            int j = 0;
            while (j < connectionList.size()) {
                IConnectionSymbol connection = (IConnectionSymbol)connectionList.get(j);
                IModelElementNodeSymbol otherSymbol = (IModelElementNodeSymbol)connection.eGet(otherSymbolFeature);
                if (other.equals(otherSymbol.getModelElement())) {
                    cmd.add((Command)new DeleteConnectionSymbolCmd(connection));
                }
                ++j;
            }
            ++i;
        }
    }

    private static IModelElement findRootElement(IModelElement model) {
        if (model instanceof IModelElementNodeSymbol) {
            model = ((IModelElementNodeSymbol)model).getModelElement();
        } else if (model instanceof TransitionConnectionType) {
            model = ((TransitionConnectionType)model).getTransition();
        }
        return model;
    }
}

