/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.ui.DereferencePathBrowser;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.validation.util.MethodFilter;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DereferencePathBrowserComposite {
    private TypeFinder typeFinder;
    private TypeInfo type;
    private Text methodText;
    private DirectionType direction = DirectionType.OUT_LITERAL;
    private boolean isConstructor = false;
    private boolean deep = true;
    private boolean includeVoidIn = false;

    public DereferencePathBrowserComposite(Composite parent, String title) {
        this.init(parent, title, 1);
    }

    public DereferencePathBrowserComposite(Composite parent, String title, int span) {
        this.init(parent, title, span);
    }

    private void init(Composite parent, final String title, int span) {
        final Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        GridData gd = FormBuilder.createDefaultSingleLineWidgetGridData();
        gd.horizontalSpan = span;
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        composite.setLayoutData((Object)gd);
        this.methodText = FormBuilder.createText((Composite)composite);
        FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.Btn_Browse, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DereferencePathBrowserComposite.this.typeFinder.setMethodFilter(DereferencePathBrowserComposite.this.createFilter());
                DereferencePathBrowser browser = new DereferencePathBrowser(composite.getShell(), DereferencePathBrowserComposite.this.type, DereferencePathBrowserComposite.this.typeFinder, title);
                browser.setConstructor(DereferencePathBrowserComposite.this.isConstructor);
                browser.setDeep(DereferencePathBrowserComposite.this.deep);
                if (browser.open() == 0 && !StringUtils.isEmpty(browser.getSelectedMethod())) {
                    DereferencePathBrowserComposite.this.methodText.setText(browser.getSelectedMethod());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private MethodFilter createFilter() {
        return new MethodFilter(){

            public boolean accept(MethodInfo info) {
                if (info.isAccessible()) {
                    if (DereferencePathBrowserComposite.this.isConstructor) {
                        return true;
                    }
                    if (DirectionType.OUT_LITERAL.equals((Object)DereferencePathBrowserComposite.this.direction)) {
                        return info.hasReturn() && info.getParameterCount() == 0;
                    }
                    if (DirectionType.IN_LITERAL.equals((Object)DereferencePathBrowserComposite.this.direction)) {
                        return info.getParameterCount() > 0 || !info.hasReturn() && DereferencePathBrowserComposite.this.includeVoidIn;
                    }
                    if (DirectionType.INOUT_LITERAL.equals((Object)DereferencePathBrowserComposite.this.direction)) {
                        return !info.isConstructor();
                    }
                }
                return false;
            }
        };
    }

    public void setType(TypeInfo type) {
        this.type = type;
    }

    public void setTypeFinder(TypeFinder typeFinder) {
        this.typeFinder = typeFinder;
    }

    public TypeFinder getTypeFinder() {
        return this.typeFinder;
    }

    public String getMethod() {
        return this.methodText.getText().trim();
    }

    public void setMethod(String methodName) {
        this.methodText.setText(methodName);
    }

    public Text getMethodText() {
        return this.methodText;
    }

    public void setDirection(DirectionType directionType) {
        this.direction = directionType;
    }

    public void setConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void setDeep(boolean isDeep) {
        this.deep = isDeep;
    }

    public void setIncludeVoidIn(boolean includeVoidIn) {
        this.includeVoidIn = includeVoidIn;
    }
}

