/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TableUtil {
    public static void createColumns(Tree tree, String[] columnNames) {
        int i = 0;
        while (i < columnNames.length) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setText(columnNames[i]);
            ++i;
        }
    }

    public static void createColumns(Table table, String[] columnNames) {
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnNames[i]);
            ++i;
        }
    }

    public static void setInitialColumnSizes(Table table, int[] columnSizes) {
        TableUtil.internalSetInitialColumnSizes((Control)table, columnSizes);
    }

    public static void setInitialColumnSizes(Tree tree, int[] columnSizes) {
        TableUtil.internalSetInitialColumnSizes((Control)tree, columnSizes);
    }

    public static void setInitialColumnSizesDirect(Control control, int[] columnSizes) {
        TableUtil.internalSetInitialColumnSizesDirect(control, columnSizes);
    }

    public static void internalSetInitialColumnSizesDirect(Control control, int[] columnSizes) {
        int columnCount = 0;
        if (!control.isDisposed() && columnSizes != null && (columnCount = TableUtil.getColumnCount(control)) > 0) {
            int cumulated = 0;
            int percentage = 0;
            int size = control.getSize().x - control.getBorderWidth() * 2;
            if (control instanceof Scrollable) {
                Rectangle clientArea = ((Scrollable)control).getClientArea();
                size = clientArea.width;
            }
            int i = 0;
            while (i < columnSizes.length) {
                if (i == columnCount) break;
                int cs = (percentage += columnSizes[i]) == 100 ? size - cumulated : size * columnSizes[i] / 100;
                Item column = TableUtil.getColumn(control, i);
                TableUtil.setWidth(column, cs);
                cumulated += cs;
                ++i;
            }
        }
    }

    public static void internalSetInitialColumnSizes(final Control control, final int[] columnSizes) {
        control.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                this.setInitialColumnSizes();
            }

            private void setInitialColumnSizes() {
                int columnCount = 0;
                if (!control.isDisposed() && columnSizes != null && (columnCount = TableUtil.getColumnCount(control)) > 0) {
                    int cumulated = 0;
                    int percentage = 0;
                    int size = control.getSize().x - control.getBorderWidth() * 2;
                    if (control instanceof Scrollable) {
                        Rectangle clientArea = ((Scrollable)control).getClientArea();
                        size = clientArea.width;
                    }
                    int i = 0;
                    while (i < columnSizes.length) {
                        if (i == columnCount) break;
                        int cs = (percentage += columnSizes[i]) == 100 ? size - cumulated : size * columnSizes[i] / 100;
                        Item column = TableUtil.getColumn(control, i);
                        TableUtil.setWidth(column, cs);
                        cumulated += cs;
                        ++i;
                    }
                }
            }
        });
    }

    private static void setWidth(Item column, int width) {
        if (column instanceof TableColumn) {
            ((TableColumn)column).setWidth(width);
        } else if (column instanceof TreeColumn) {
            ((TreeColumn)column).setWidth(width);
        }
    }

    private static Item getColumn(Control control, int index) {
        return control instanceof Table ? ((Table)control).getColumn(index) : (control instanceof Tree ? ((Tree)control).getColumn(index) : null);
    }

    private static int getColumnCount(Control control) {
        return control instanceof Table ? ((Table)control).getColumnCount() : (control instanceof Tree ? ((Tree)control).getColumnCount() : 0);
    }

    public static void setLabelProvider(TreeViewer viewer, TableLabelProvider provider, String[] attributes) {
        TableUtil.internalSetLabelProvider((StructuredViewer)viewer, provider, attributes);
    }

    public static void setLabelProvider(TableViewer viewer, TableLabelProvider provider, String[] attributes) {
        TableUtil.internalSetLabelProvider((StructuredViewer)viewer, provider, attributes);
    }

    private static void internalSetLabelProvider(StructuredViewer viewer, final TableLabelProvider provider, final String[] attributes) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return provider.getImage(element);
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (provider.isNamed() && columnIndex < attributes.length) {
                    return provider.getText(attributes[columnIndex], element);
                }
                return provider.getText(columnIndex, element);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                int i = 0;
                while (i < attributes.length) {
                    if (property.equals(attributes[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }
}

