/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotBooleanEditor;
import org.eclipse.stardust.modeling.core.editors.ui.DefaultTableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ActivityQualityControlCodesViewer {
    private static final String[] registryColumns = new String[]{Diagram_Messages.QUALITY_CONTROL_CODE, Diagram_Messages.QUALITY_CONTROL_DESCRIPTION, Diagram_Messages.QUALITY_CONTROL_CODE_AVAILABLE};
    private TreeViewer viewer;
    private CarnotBooleanEditor editInStructure;
    private Object input;
    private EList<Code> validQualityCodes;

    public Control createControl(Composite composite) {
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, registryColumns);
        TableUtil.setInitialColumnSizes(tree, new int[]{30, 60, 10});
        DefaultTableLabelProvider labelProvider = new DefaultTableLabelProvider(null){

            @Override
            public String getText(int index, Object element) {
                switch (index) {
                    case 0: {
                        return ((Code)element).getCode();
                    }
                    case 1: {
                        return ((Code)element).getValue();
                    }
                }
                return "";
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)labelProvider, registryColumns);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                EList list = (EList)inputElement;
                Object[] data = list.toArray(new Object[list.size()]);
                return data;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.editInStructure = new CarnotBooleanEditor(2){

            @Override
            public boolean canEdit(Object element) {
                return true;
            }

            @Override
            public Object getValue(Object element) {
                if (ActivityQualityControlCodesViewer.this.validQualityCodes.contains(element)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public void setValue(Object element, Object value) {
                if (value.equals(Boolean.TRUE)) {
                    ActivityQualityControlCodesViewer.this.validQualityCodes.add((Object)((Code)element));
                } else {
                    ActivityQualityControlCodesViewer.this.validQualityCodes.remove((Object)((Code)element));
                }
            }
        };
        this.editInStructure.setTree(tree);
        return tree;
    }

    public void setInput(Object input, ActivityType activity) {
        this.validQualityCodes = activity.getValidQualityCodes();
        this.input = input;
        this.viewer.setInput(input);
        this.editInStructure.setTree(this.viewer.getTree());
        this.editInStructure.refresh();
        this.viewer.refresh();
        this.viewer.expandAll();
    }
}

