/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.Map;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.AbstractWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.core.ui.DatePickerComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PrimitiveDataWidgetAdapter
extends AbstractWidgetAdapter {
    private final ComboViewer typeViewer;
    private ISelectionChangedListener dataListener;
    private final Composite valueComposite;
    private final Map valueControlsMap;

    public PrimitiveDataWidgetAdapter(ComboViewer typeViewer, Composite valueComposite, Map valueControlsMap) {
        this.typeViewer = typeViewer;
        this.valueComposite = valueComposite;
        this.valueControlsMap = valueControlsMap;
    }

    public void bind(IBindingMediator manager) {
        super.bind(manager);
        this.dataListener = this.createDataListener();
        this.typeViewer.addSelectionChangedListener(this.dataListener);
        this.typeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PrimitiveDataWidgetAdapter.this.unbind();
            }
        });
    }

    private ISelectionChangedListener createDataListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Type data = PrimitiveDataWidgetAdapter.this.getData(event.getSelection());
                if (data != null) {
                    PrimitiveDataWidgetAdapter.this.updatePrimitiveDataValue(data);
                    PrimitiveDataWidgetAdapter.this.updateModel(data);
                }
            }
        };
    }

    private void updatePrimitiveDataValue(Type data) {
        data = data == null ? Type.String : data;
        Object object = this.valueControlsMap.get(data);
        ((StackLayout)this.valueComposite.getLayout()).topControl = object instanceof DatePickerComposite ? ((DatePickerComposite)object).getCalendarComposite() : (Control)object;
        this.valueComposite.layout();
    }

    public void updateVisuals(Object types) {
        ISelection selection = this.typeViewer.getSelection();
        this.typeViewer.setInput(types);
        this.typeViewer.setSelection(selection);
        this.updatePrimitiveDataValue(this.getData(selection));
    }

    public void unbind() {
        if (this.dataListener != null) {
            if (!this.typeViewer.getControl().isDisposed()) {
                this.typeViewer.removeSelectionChangedListener(this.dataListener);
            }
            this.dataListener = null;
        }
        super.unbind();
    }

    private Type getData(ISelection selection) {
        IStructuredSelection structuredSelection;
        Type data = null;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            data = (Type)structuredSelection.getFirstElement();
        }
        return data;
    }
}

