/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SplitJoinDialog
extends Dialog {
    private Button[] buttons;
    private Button saveButton;
    private FlowControlType flow;
    private JoinSplitType selectedType;

    public JoinSplitType getSelectedType() {
        return this.selectedType;
    }

    protected void okPressed() {
        boolean save = this.saveButton.getSelection();
        if (save) {
            PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature" + this.flow.getLiteral() + "Prompt", false);
        }
        int i = 0;
        JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
        int n = joinSplitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JoinSplitType type = joinSplitTypeArray[n2];
            if (type != JoinSplitType.NONE_LITERAL) {
                boolean selected = this.buttons[i++].getSelection();
                if (save) {
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature" + this.flow.getLiteral() + type.getLiteral(), selected);
                }
                if (selected) {
                    this.selectedType = type;
                }
            }
            ++n2;
        }
        super.okPressed();
    }

    public SplitJoinDialog(Shell parentShell, FlowControlType flow) {
        super(parentShell);
        this.flow = flow;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MessageFormat.format(Diagram_Messages.SplitJoinDialog_Title, BpmUiActivator.i18n((FlowControlType)this.flow)));
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        ((GridLayout)panel.getLayout()).numColumns = JoinSplitType.values().length;
        this.buttons = new Button[JoinSplitType.values().length - 1];
        int i = 0;
        JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
        int n = joinSplitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JoinSplitType type = joinSplitTypeArray[n2];
            if (type != JoinSplitType.NONE_LITERAL) {
                this.buttons[i++] = FormBuilder.createRadioButton((Composite)panel, (String)BpmUiActivator.i18n((JoinSplitType)type));
            }
            ++n2;
        }
        this.saveButton = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.SplitJoinDialog_Save);
        this.saveButton.setSelection(false);
        return panel;
    }
}

