/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.actions.ISpiAction;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class CreateCompositeAction
extends Action
implements ISpiAction {
    private TypeDeclarationType declaration;
    private IStructuredSelection selection;
    private WorkflowModelEditor editor;

    protected List<?> getSelectedObjects() {
        return this.selection instanceof IStructuredSelection ? this.selection.toList() : Collections.EMPTY_LIST;
    }

    public void setConfiguration(IConfigurationElement config, WorkflowModelEditor editor, IStructuredSelection selection) {
        this.setId(config.getAttribute("id"));
        this.setText(Structured_Messages.CreateCompositeAction_ActionLabel);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"{org.eclipse.xsd.edit}icons/full/obj16/XSDComplexTypeDefinition.gif"));
        this.editor = editor;
        this.selection = selection;
    }

    public boolean isEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        return selection instanceof TreeEditPart && ((TreeEditPart)selection).getModel() instanceof TypeDeclarationsType;
    }

    private TypeDeclarationsType getTypeDeclarationsType() {
        Object selection = this.getSelectedObjects().get(0);
        return (TypeDeclarationsType)((TreeEditPart)selection).getModel();
    }

    public void run() {
        this.editor.getEditDomain().getCommandStack().execute((Command)this.createCommand());
    }

    private SetValueCmd createCommand() {
        IdFactory idFactory = new IdFactory(Structured_Messages.CreateCompositeAction_BaseId, Structured_Messages.CreateCompositeAction_BaseName, XpdlPackage.eINSTANCE.getTypeDeclarationType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Name());
        this.declaration = XpdlFactory.eINSTANCE.createTypeDeclarationType();
        TypeDeclarationsType parent = this.getTypeDeclarationsType();
        idFactory.computeNames((List)parent.getTypeDeclaration());
        this.declaration.setId(idFactory.getId());
        this.declaration.setName(idFactory.getName());
        String visibilityDefault = PlatformUI.getPreferenceStore().getString("multiPackageModelingVisibility");
        if (visibilityDefault == null || visibilityDefault == "" || visibilityDefault.equalsIgnoreCase("Public")) {
            ExtendedAttributeUtil.createAttribute((Extensible)this.declaration, (String)"carnot:engine:visibility").setValue("Public");
        } else {
            ExtendedAttributeUtil.createAttribute((Extensible)this.declaration, (String)"carnot:engine:visibility").setValue("Private");
        }
        SchemaTypeType schema = XpdlFactory.eINSTANCE.createSchemaTypeType();
        this.declaration.setSchemaType(schema);
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xsdSchema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        ModelType model = (ModelType)parent.eContainer();
        xsdSchema.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((ModelType)model, (String)this.declaration.getId()));
        String prefix = TypeDeclarationUtils.computePrefix((String)this.declaration.getId(), xsdSchema.getQNamePrefixToNamespaceMap().keySet());
        xsdSchema.getQNamePrefixToNamespaceMap().put(prefix, xsdSchema.getTargetNamespace());
        xsdSchema.setSchemaLocation("urn:internal:" + this.declaration.getId());
        schema.setSchema(xsdSchema);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(this.declaration.getId());
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        particle.setContent((XSDParticleContent)modelGroup);
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.declaration.getId());
        xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdSchema.getContents().add((Object)xsdElementDeclaration);
        return new SetValueCmd((EObject)parent, (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationsType_TypeDeclaration(), this.declaration){

            public void redo() {
                super.redo();
                CreationUtils.showInOutlineAndEdit((EObject)CreateCompositeAction.this.declaration);
            }

            public void undo() {
                super.undo();
            }
        };
    }
}

