/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtendedAnnotationType;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.data.structured.annotations.AnnotationContentProvider;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.GenericElementAdapter;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class CategoryAnnotation
implements IAnnotation {
    private IConfigurationElement config;
    private XSDFeature element;
    private List<IAnnotation> children;
    private AnnotationContentProvider provider;
    static final String ANY = "any";

    public CategoryAnnotation(AnnotationContentProvider provider, XSDFeature element, IConfigurationElement config) {
        this.provider = provider;
        this.element = element;
        this.config = config;
    }

    private ExtendedAttributeType getExternalAnnotationAttribute() {
        return ExtendedAttributeUtil.getAttribute((Extensible)this.provider.getDeclaration(), (String)"carnot:engine:resource:mapping:annotations");
    }

    @Override
    public IConfigurationElement getConfiguration() {
        return this.config;
    }

    public String getId() {
        return this.config.getAttribute("id");
    }

    @Override
    public String getName() {
        return this.config.getAttribute("name");
    }

    @Override
    public List<IAnnotation> getChildren() {
        if (this.children == null) {
            IConfigurationElement[] elements = this.config.getChildren("element");
            this.children = CollectionUtils.newList();
            int i = 0;
            while (i < elements.length) {
                this.children.add(new ElementAnnotation(this, elements[i]));
                ++i;
            }
        }
        return this.children;
    }

    @Override
    public IAnnotation getParent() {
        return null;
    }

    public boolean canModify() {
        return false;
    }

    @Override
    public boolean exists() {
        List<IAnnotation> children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ElementAnnotation element = (ElementAnnotation)children.get(i);
            if (element.exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getNamespace() {
        return this.config.getAttribute("namespace");
    }

    public String getDefaultPrefix() {
        return this.config.getAttribute("defaultPrefix");
    }

    @Override
    public String getRawValue() {
        return this.getRawValue(this.getElement());
    }

    @Override
    public String getRawValue(XSDFeature element) {
        return null;
    }

    @Override
    public void setRawValue(String value) {
        this.setRawValue(this.getElement(), value);
    }

    @Override
    public void setRawValue(XSDFeature element, String value) {
    }

    public XSDAnnotation getAnnotation(XSDFeature element, boolean create, boolean forceInternal) {
        if (create && forceInternal) {
            return null;
        }
        XSDAnnotation annotation = null;
        if (this.provider.isInternalSchema() && forceInternal) {
            return null;
        }
        if (this.provider.isInternalSchema() || forceInternal) {
            annotation = this.getInternalAnnotation(element, create);
        } else {
            annotation = this.getExternalAnnotation(element, create);
            if (annotation == null && !create) {
                annotation = this.getInternalAnnotation(element, false);
            }
        }
        return annotation;
    }

    private XSDAnnotation getInternalAnnotation(XSDFeature element, boolean create) {
        if (element == null) {
            return null;
        }
        XSDAnnotation annotation = GenericElementAdapter.getAnnotation(element);
        if (annotation == null && create) {
            annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            GenericElementAdapter.setAnnotation(element, annotation);
            if (annotation.getElement() == null) {
                annotation.updateElement();
            }
        }
        return annotation;
    }

    private XSDAnnotation getExternalAnnotation(XSDFeature element, boolean create) {
        if (element == null) {
            return null;
        }
        ExtendedAnnotationType annotation = null;
        ExtendedAttributeType externalAnnotationAttribute = this.getExternalAnnotationAttribute();
        if (externalAnnotationAttribute == null && create) {
            externalAnnotationAttribute = ExtendedAttributeUtil.createAttribute((Extensible)this.provider.getDeclaration(), (String)"carnot:engine:resource:mapping:annotations");
        }
        if (externalAnnotationAttribute != null && (annotation = externalAnnotationAttribute.getExtendedAnnotation()) == null && create) {
            annotation = ExtensionFactory.eINSTANCE.createExtendedAnnotationType();
            externalAnnotationAttribute.setExtendedAnnotation(annotation);
            annotation.updateElement();
        }
        return annotation;
    }

    public String getSourceURI(XSDConcreteComponent component) {
        if (this.provider.isInternalSchema()) {
            return ANY;
        }
        List path = CollectionUtils.newList();
        while (component != null && !(component instanceof XSDSchema)) {
            if (component instanceof XSDFeature) {
                path.add(((XSDFeature)component).getName());
            } else if (component instanceof XSDNamedComponent && component.eContainer() instanceof XSDSchema) {
                path.add(((XSDNamedComponent)component).getName());
            }
            component = component.getContainer();
        }
        StringBuffer sb = new StringBuffer();
        int i = path.size() - 1;
        while (i >= 0) {
            sb.append((String)path.get(i));
            if (i > 0) {
                sb.append('/');
            }
            --i;
        }
        return sb.toString();
    }

    public void setElementDeclaration(XSDFeature element) {
        this.element = element;
    }

    @Override
    public XSDFeature getElement() {
        return this.element;
    }
}

