/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.eclipse.stardust.common.error.ValidationException;
import org.eclipse.stardust.engine.core.compatibility.gui.AbstractDialog;
import org.eclipse.stardust.engine.core.compatibility.gui.GUI;
import org.eclipse.stardust.engine.core.compatibility.gui.GenericTree;
import org.eclipse.stardust.modeling.debug.interpreter.Column;
import org.eclipse.stardust.modeling.debug.interpreter.CreateDataDialog;
import org.eclipse.stardust.modeling.debug.interpreter.CreateOrModifyColumnDialog;
import org.eclipse.stardust.modeling.debug.interpreter.CreateOrModifyTableDataDialog;
import org.eclipse.stardust.modeling.debug.interpreter.CreateSubGroupDialog;
import org.eclipse.stardust.modeling.debug.interpreter.Data;
import org.eclipse.stardust.modeling.debug.interpreter.DataGroup;
import org.eclipse.stardust.modeling.debug.interpreter.DefaultInterpreter;
import org.eclipse.stardust.modeling.debug.interpreter.TableData;

public class MetadataEditor
extends AbstractDialog {
    private static Class[] treeClasses = new Class[]{DataGroup.class, TableData.class, Data.class, Column.class};
    private static String[][] treeAssociations;
    private static String[] treeNames;
    private static MetadataEditor instance;
    private GenericTree tree;
    private JMenuItem dataGroupPropertiesItem;
    private JMenuItem addDataItem;
    private JMenuItem addSubGroupItem;
    private JMenuItem dataPropertiesItem;
    private JMenuItem tableDataPropertiesItem;
    private JMenuItem columnPropertiesItem;
    private DataGroup topGroup;
    private DefaultInterpreter interpreter;
    private JPanel viewPanel;

    static {
        String[][] stringArrayArray = new String[4][];
        stringArrayArray[0] = new String[]{"SubGroups", "Data"};
        stringArrayArray[1] = new String[]{"Columns"};
        treeAssociations = stringArrayArray;
        treeNames = new String[]{"Label", "Label", "Label", "Label"};
    }

    protected MetadataEditor() {
        this(null);
    }

    protected MetadataEditor(Frame parent) {
        super(parent);
        this.setResizable(true);
        this.interpreter = new DefaultInterpreter();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.addDataItem) {
            CreateDataDialog.showDialog(this, (DataGroup)this.tree.getPopupObject(), JOptionPane.getFrameForComponent((Component)((Object)this)));
            this.tree.reload(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else if (event.getSource() == this.addSubGroupItem) {
            CreateSubGroupDialog.showDialog(this, (DataGroup)this.tree.getPopupObject(), true, JOptionPane.getFrameForComponent((Component)((Object)this)));
            this.tree.reload(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else if (event.getSource() == this.dataGroupPropertiesItem) {
            CreateSubGroupDialog.showDialog(this, (DataGroup)this.tree.getPopupObject());
            this.tree.objectChanged(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else if (event.getSource() == this.dataPropertiesItem) {
            CreateDataDialog.showDialog(this, (Data)this.tree.getPopupObject());
            this.tree.objectChanged(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else if (event.getSource() == this.tableDataPropertiesItem) {
            CreateOrModifyTableDataDialog.showDialog(this, (TableData)this.tree.getPopupObject(), JOptionPane.getFrameForComponent((Component)((Object)this)));
            this.tree.objectChanged(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else if (event.getSource() == this.columnPropertiesItem) {
            CreateOrModifyColumnDialog.showDialog(this, (Column)this.tree.getPopupObject(), JOptionPane.getFrameForComponent((Component)((Object)this)));
            this.tree.objectChanged(this.tree.getPopupObject());
            this.viewPanel.removeAll();
            this.viewPanel.add(this.interpreter.createGroupComponent(this.topGroup));
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else {
            super.actionPerformed(event);
        }
    }

    public JComponent createContent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(GUI.getEmptyPanelBorder());
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BoxLayout(this.viewPanel, 1));
        this.viewPanel.setBorder(new TitledBorder(new EtchedBorder(), "Activity Dialog"));
        panel.add(this.viewPanel);
        panel.add(Box.createHorizontalStrut(10));
        this.tree = new GenericTree(treeClasses, treeAssociations, treeNames);
        this.tree.setPopupMenu(this.getDataGroupPopupMenu(), DataGroup.class);
        this.tree.setPopupMenu(this.getDataPopupMenu(), Data.class);
        this.tree.setPopupMenu(this.getTableDataPopupMenu(), TableData.class);
        this.tree.setPopupMenu(this.getColumnPopupMenu(), Column.class);
        this.tree.setIconMethod("getIcon", DataGroup.class);
        this.tree.setIconMethod("getIcon", Data.class);
        this.tree.setIconMethod("getIcon", TableData.class);
        this.tree.setIconMethod("getIcon", Column.class);
        this.tree.setLoadIncrement(100000);
        this.tree.setDragAndDropEnabled(true);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree);
        panel.add(scrollPane);
        scrollPane.setMinimumSize(new Dimension(200, 400));
        scrollPane.setPreferredSize(new Dimension(200, 400));
        scrollPane.setMaximumSize(new Dimension(1000, 1000));
        return panel;
    }

    public void validateSettings() throws ValidationException {
    }

    private JPopupMenu getColumnPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.columnPropertiesItem = new JMenuItem("Properties...");
        this.columnPropertiesItem.addActionListener((ActionListener)((Object)this));
        this.columnPropertiesItem.setMnemonic('e');
        popupMenu.add(this.columnPropertiesItem);
        return popupMenu;
    }

    private JPopupMenu getDataGroupPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.dataGroupPropertiesItem = new JMenuItem("Properties...");
        this.dataGroupPropertiesItem.addActionListener((ActionListener)((Object)this));
        this.dataGroupPropertiesItem.setMnemonic('e');
        popupMenu.add(this.dataGroupPropertiesItem);
        popupMenu.addSeparator();
        this.addDataItem = new JMenuItem("Add Data...");
        this.addDataItem.addActionListener((ActionListener)((Object)this));
        this.addDataItem.setMnemonic('e');
        popupMenu.add(this.addDataItem);
        this.addSubGroupItem = new JMenuItem("Add Subgroup...");
        this.addSubGroupItem.addActionListener((ActionListener)((Object)this));
        this.addSubGroupItem.setMnemonic('e');
        popupMenu.add(this.addSubGroupItem);
        popupMenu.addSeparator();
        return popupMenu;
    }

    private JPopupMenu getDataPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.dataPropertiesItem = new JMenuItem("Properties...");
        this.dataPropertiesItem.addActionListener((ActionListener)((Object)this));
        this.dataPropertiesItem.setMnemonic('e');
        popupMenu.add(this.dataPropertiesItem);
        return popupMenu;
    }

    private JPopupMenu getTableDataPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.tableDataPropertiesItem = new JMenuItem("Properties...");
        this.tableDataPropertiesItem.addActionListener((ActionListener)((Object)this));
        this.tableDataPropertiesItem.setMnemonic('p');
        popupMenu.add(this.tableDataPropertiesItem);
        return popupMenu;
    }

    public void setData(DataGroup topGroup) {
        this.topGroup = topGroup;
        this.tree.setRootObject((Object)topGroup);
        this.viewPanel.add(this.interpreter.createGroupComponent(topGroup));
    }

    public static boolean showDialog(JDialog dialog, DataGroup topGroup) {
        return MetadataEditor.showDialog(dialog, topGroup, null);
    }

    public static boolean showDialog(JDialog dialog, DataGroup topGroup, Frame parent) {
        if (instance == null) {
            instance = new MetadataEditor(parent);
        }
        instance.setData(topGroup);
        return MetadataEditor.showDialog((String)"Manual Activity Dialog Editor", (AbstractDialog)instance, (JDialog)dialog);
    }
}

