/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.refactoring.RefactoringUtils;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.AttributeValueChange;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class InteractiveApplicationOperator
implements IJdtOperator {
    private String[] typeIds;

    public InteractiveApplicationOperator(String[] ids) {
        this.typeIds = ids;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalPackageName = null;
        String newPackageName = null;
        if (element instanceof IPackageFragment) {
            originalPackageName = ((IPackageFragment)element).getElementName();
            newPackageName = OperatorsRegistry.getNewPackageName((IPackageFragment)element, arguments);
            if (newPackageName.equals(originalPackageName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newPackageName == null && newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList contextTypes = model.getApplicationContextType();
        int i = 0;
        while (i < contextTypes.size()) {
            ApplicationContextTypeType type = (ApplicationContextTypeType)contextTypes.get(i);
            int j = 0;
            while (j < this.typeIds.length) {
                String typeId = this.typeIds[j];
                if (typeId.equals(type.getId())) {
                    EList contexts = type.getContexts();
                    int k = 0;
                    while (k < contexts.size()) {
                        ContextType ctx = (ContextType)contexts.get(k);
                        if (element instanceof IPackageFragment) {
                            this.processPackage(result, ctx, originalPackageName, newPackageName);
                        } else if (element instanceof IType) {
                            this.processClass(result, ctx, originalClassName, newClassName);
                            this.processParams(result, ctx, originalClassName, newClassName);
                        } else if (element instanceof IMethod) {
                            this.processMethods(result, ctx, originalMethodName, newMethodName);
                        }
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String packageName = null;
        if (element instanceof IPackageFragment) {
            packageName = ((IPackageFragment)element).getElementName();
        }
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (packageName == null && className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList contextTypes = model.getApplicationContextType();
        int i = 0;
        while (i < contextTypes.size()) {
            ApplicationContextTypeType type = (ApplicationContextTypeType)contextTypes.get(i);
            int j = 0;
            while (j < this.typeIds.length) {
                String typeId = this.typeIds[j];
                if (typeId.equals(type.getId())) {
                    EList contexts = type.getContexts();
                    int k = 0;
                    while (k < contexts.size()) {
                        ContextType ctx = (ContextType)contexts.get(k);
                        if (!(element instanceof IPackageFragment)) {
                            if (element instanceof IType) {
                                this.queryClass(result, file, ctx, className);
                                this.queryParams(result, file, ctx, className);
                            } else if (element instanceof IMethod) {
                                this.queryMethods(result, file, ctx, methodName);
                            }
                        }
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void queryParams(List result, IFile file, ContextType context, String className) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:methodName");
        if (attribute != null) {
            EObjectMatch.addParamsMatch(result, file, attribute, className);
        }
    }

    private void processParams(List result, ContextType context, String originalClassName, String newClassName) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:methodName");
        if (attribute != null) {
            EObjectStringValueSubstituteChange.addParamsSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalClassName, newClassName);
        }
    }

    private void queryMethods(List result, IFile file, ContextType context, String methodName) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:methodName");
        if (attribute != null) {
            EObjectMatch.addMethodMatch(result, file, attribute, methodName);
        }
    }

    private void processMethods(List result, ContextType context, String originalMethodName, String newMethodName) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:methodName");
        if (attribute != null) {
            EObjectStringValueSubstituteChange.addMethodSubstitution(result, attribute.getName(), (EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), originalMethodName, newMethodName);
        }
    }

    private void queryClass(List result, IFile file, ContextType context, String className) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:className");
        if (attribute != null && className.equals(attribute.getValue())) {
            result.add(new EObjectMatch(file, attribute, 0, className.length()));
        }
    }

    private void processClass(List result, ContextType context, String originalClassName, String newClassName) {
        String className;
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:className");
        if (attribute != null && originalClassName.equals(className = attribute.getValue())) {
            result.add(new AttributeValueChange(attribute, newClassName));
        }
    }

    private void processPackage(List result, ContextType context, String originalClassName, String newClassName) {
        String className;
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)context, (String)"carnot:engine:className");
        if (attribute != null && RefactoringUtils.containsPackage(className = attribute.getValue(), originalClassName)) {
            result.add(new AttributeValueChange(attribute, RefactoringUtils.getNewClassName(className, originalClassName, newClassName)));
        }
    }
}

