/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.query.matches;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.search.ui.text.Match;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;

public class EObjectMatch
extends Match {
    private IFile file;

    public EObjectMatch(IFile file, EObject eObject, EStructuralFeature feature, int offset, int length) {
        super((Object)eObject, offset, length);
        this.file = file;
    }

    public EObjectMatch(IFile file, AttributeType attribute, int offset, int length) {
        super((Object)attribute, offset, length);
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    public static void addMethodMatch(List result, IFile file, AttributeType attribute, String methodName) {
        String oldValue = attribute.getValue();
        if (oldValue != null) {
            int ix = oldValue.lastIndexOf(40);
            StringTokenizer st = new StringTokenizer(ix >= 0 ? oldValue.substring(0, ix) : oldValue, ".");
            while (st.hasMoreTokens()) {
                String token = EObjectMatch.trim(st.nextToken(), false);
                if (!methodName.equals(token)) continue;
                result.add(new EObjectMatch(file, attribute, 0, ix < 0 ? oldValue.length() : ix));
                break;
            }
        }
    }

    public static void addMethodMatch(List result, IFile file, EObject eObject, EStructuralFeature feature, String methodName) {
        String oldValue = (String)eObject.eGet(feature);
        if (oldValue != null) {
            int ix = oldValue.lastIndexOf(40);
            StringTokenizer st = new StringTokenizer(ix >= 0 ? oldValue.substring(0, ix) : oldValue, ".");
            while (st.hasMoreTokens()) {
                String token = EObjectMatch.trim(st.nextToken(), false);
                if (!methodName.equals(token)) continue;
                result.add(new EObjectMatch(file, eObject, feature, 0, ix < 0 ? oldValue.length() : ix));
                break;
            }
        }
    }

    public static void addParamsMatch(List result, IFile file, AttributeType attribute, String className) {
        String oldValue = attribute.getValue();
        if (oldValue != null && oldValue.endsWith(")")) {
            int ix = oldValue.lastIndexOf(40);
            if (ix++ > 0) {
                StringTokenizer st = new StringTokenizer(oldValue.substring(ix, oldValue.length() - 1), ",");
                while (st.hasMoreTokens()) {
                    String token = EObjectMatch.trim(st.nextToken(), true);
                    if (!className.equals(token)) continue;
                    result.add(new EObjectMatch(file, attribute, ix, oldValue.length() - 1));
                    break;
                }
            }
        }
    }

    public static void addParamsMatch(List result, IFile file, EObject eObject, EStructuralFeature feature, String className) {
        String oldValue = (String)eObject.eGet(feature);
        if (oldValue != null && oldValue.endsWith(")")) {
            int ix = oldValue.lastIndexOf(40);
            if (ix++ > 0) {
                StringTokenizer st = new StringTokenizer(oldValue.substring(ix, oldValue.length() - 1), ",");
                while (st.hasMoreTokens()) {
                    String token = EObjectMatch.trim(st.nextToken(), true);
                    if (!className.equals(token)) continue;
                    result.add(new EObjectMatch(file, eObject, feature, ix, oldValue.length() - 1));
                    break;
                }
            }
        }
    }

    private static String trim(String token, boolean paramSubstitution) {
        int ix;
        if (!paramSubstitution && (ix = token.indexOf(40)) >= 0) {
            token = token.substring(0, ix);
        }
        return token.trim();
    }
}

