/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.file;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.AbstractConnectionPropertyPage;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.ExtendedModelManager;
import org.eclipse.stardust.modeling.repository.common.RepositoryPackage;
import org.eclipse.stardust.modeling.repository.file.FileConnectionHandler;
import org.eclipse.stardust.modeling.repository.file.FilePathUtil;
import org.eclipse.stardust.modeling.repository.file.File_Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

public class FileConnectionPropertyPage
extends AbstractConnectionPropertyPage {
    private RepositoryPackage PKG = RepositoryPackage.eINSTANCE;
    private BindingManager bndMgr = new BindingManager();
    private static final String FILENAME = "filename";
    private LabeledText text;
    private String filename;
    protected LabeledText txtId;
    protected LabeledText txtName;
    private Button byReferenceCheckbox;
    private ModelType referencedModel = null;

    public void dispose() {
        Connection connection = this.getConnection();
        this.bndMgr.unbind((EObject)connection, (Widget)this.txtId.getText());
        this.bndMgr.unbind((EObject)connection, (Widget)this.txtName.getText());
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Composite composite1 = FormBuilder.createComposite((Composite)composite, (int)2);
        this.txtId = FormBuilder.createLabeledText((Composite)composite1, (String)File_Messages.LBL_ID);
        this.txtName = FormBuilder.createLabeledText((Composite)composite1, (String)File_Messages.LBL_TXT_NAME);
        FormBuilder.createLabel((Composite)composite1, (String)"");
        this.byReferenceCheckbox = FormBuilder.createCheckBox((Composite)composite1, (String)File_Messages.BOX_IMPORT_BY_REFERENCE);
        FormBuilder.createHorizontalSeparator((Composite)composite, (int)1);
        Composite composite2 = FormBuilder.createComposite((Composite)composite, (int)3);
        this.text = FormBuilder.createLabeledText((Composite)composite2, (String)File_Messages.LBL_TXT);
        FormBuilder.createButton((Composite)composite2, (String)File_Messages.BUT_BW, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(FileConnectionPropertyPage.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xpdl"});
                String fileName = FileConnectionPropertyPage.this.text.getText().getText();
                if (!StringUtils.isEmpty((String)fileName)) {
                    File file = FileConnectionHandler.resolve(FileConnectionPropertyPage.this.getConnection(), fileName);
                    dialog.setFilterPath(file.getParent());
                    dialog.setFileName(file.getName());
                }
                if ((fileName = dialog.open()) != null) {
                    java.net.URI fileURI = new File(fileName).toURI();
                    java.net.URI platformRelative = Platform.getLocation().toFile().toURI().relativize(fileURI);
                    if (platformRelative != fileURI) {
                        java.net.URI projectURI;
                        java.net.URI projectRelative;
                        Connection connection = FileConnectionPropertyPage.this.getConnection();
                        ConnectionManager manager = (ConnectionManager)connection.getProperty("ConnectionManager");
                        ModelType model = manager.getModel();
                        URI modelURI = model.eResource().getURI();
                        if (modelURI.isPlatformResource() && (projectRelative = (projectURI = java.net.URI.create(modelURI.segment(1))).relativize(platformRelative)) != platformRelative) {
                            String path = FilePathUtil.isSameFolder(model, projectRelative);
                            if (path != null) {
                                FileConnectionPropertyPage.this.text.getText().setText(path);
                                return;
                            }
                            FileConnectionPropertyPage.this.text.getText().setText("project:/" + projectRelative);
                            return;
                        }
                        FileConnectionPropertyPage.this.text.getText().setText("platform:/" + platformRelative);
                    } else {
                        FileConnectionPropertyPage.this.text.getText().setText(fileName);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Connection connection = this.getConnection();
        this.bndMgr.bind((EObject)connection, (EStructuralFeature)this.PKG.getConnection_Id(), this.txtId.getText());
        this.bndMgr.bind((EObject)connection, (EStructuralFeature)this.PKG.getConnection_Name(), this.txtName.getText());
        String byReference = this.getAttribute("importByReference");
        if ("true".equals(byReference)) {
            this.byReferenceCheckbox.setSelection(true);
        }
        this.filename = this.getAttribute(FILENAME);
        this.text.getText().setText(this.filename == null ? "" : this.filename);
        return composite;
    }

    public boolean performOk() {
        String fileName = this.text.getText().getText();
        File file = FileConnectionHandler.resolve(this.getConnection(), fileName);
        if (!file.exists() || file.isDirectory()) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
            messageBox.setText(File_Messages.TXT_WR);
            messageBox.setMessage(File_Messages.MSG_PLEASE_PROVIDE_A_VALID_FILENAME);
            messageBox.open();
            return false;
        }
        if (this.byReferenceCheckbox.getSelection() && this.checkForCircularReference(file)) {
            return false;
        }
        this.setAttribute("importByReference", this.byReferenceCheckbox.getSelection() ? "true" : "false");
        this.setAttribute(FILENAME, fileName);
        AttributeType version = AttributeUtil.getAttribute((IExtensibleElement)this.referencedModel, (String)"carnot:engine:version");
        if (this.referencedModel != null && version != null) {
            this.setAttribute("version", version.getValue().toString());
        }
        this.connectionPropertiesChanged();
        if (this.getElement() != null) {
            ((TreeEditPart)this.getElement()).refresh();
        }
        return true;
    }

    private boolean checkForCircularReference(File file) {
        boolean result = false;
        ModelElementPropertyDialog med = (ModelElementPropertyDialog)this.getContainer();
        String modelID = med.getEditor().getWorkflowModel().getId();
        try {
            this.referencedModel = ExtendedModelManager.loadModel((File)file);
            ConnectionManager manager = new ConnectionManager(this.referencedModel);
            manager.resolve();
            this.referencedModel.setConnectionManager((IConnectionManager)manager);
            result = ModelUtils.hasCircularDependency((String)modelID, (ModelType)this.referencedModel);
            if (result) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
                messageBox.setText(File_Messages.TXT_CIRCULAR_DEPENDENCY_DETECTED);
                String message = MessageFormat.format(File_Messages.MSG_IS_DIRECTLY_OR_INDIRECTLY_REFERENCED_BY_MD, modelID, this.referencedModel.getId());
                message = String.valueOf(message) + "\n\n" + File_Messages.MSG_CIRCULAR_REFERENCES_BETWEEN_MD_FILES_ARE_NOT_ALLOWED;
                messageBox.setMessage(message);
                messageBox.open();
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

