/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.defaulttemplate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stardust.engine.api.model.IDataType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Coordinates;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.RoutingType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.templates.Templates_Messages;
import org.eclipse.stardust.modeling.templates.defaulttemplate.TemplateParameterWizard;
import org.eclipse.stardust.modeling.templates.emf.template.DocumentationType;
import org.eclipse.stardust.modeling.templates.emf.template.ReferenceType;
import org.eclipse.stardust.modeling.templates.emf.template.RootsType;
import org.eclipse.stardust.modeling.templates.emf.template.StyleType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateLibraryType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateType;
import org.eclipse.stardust.modeling.templates.emf.template.impl.TemplatesTypeImpl;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateAdapter
implements ITemplate {
    private TemplateType template;
    private EcoreUtil.Copier copier;
    private ITemplateFactory parentTemplateFactory;
    private ModelType targetModel;
    private EditPart editPart;
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;

    public TemplateAdapter(TemplateType template, ITemplateFactory templateFactory) {
        this.template = template;
        this.parentTemplateFactory = templateFactory;
    }

    @Override
    public String getId() {
        return this.template.getId();
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    @Override
    public void setName(String name) {
        this.template.setName(name);
    }

    @Override
    public String getDescription() {
        DocumentationType documentation;
        if (this.template != null && (documentation = this.template.getDocumentation()) != null) {
            return documentation.getAsText();
        }
        return null;
    }

    public String getCategory() {
        return this.template.getCategory();
    }

    @Override
    public void applyTemplate(WorkflowModelEditor editor, ModelType targetModel, DiagramType targetDiagram, EditPart editPart, int xHint, int yHint) {
        this.targetModel = targetModel;
        this.editPart = editPart;
        if (StyleType.EMBEDDED.equals((Object)this.template.getStyle())) {
            this.embedTemplate(targetModel, targetDiagram, xHint, yHint);
        }
        ModelUtils.resolve((ModelType)targetModel, (IExtensibleElement)targetModel);
        if (this.template.getRoots() != null) {
            final TemplateParameterWizard wizard = new TemplateParameterWizard(targetModel, this.template, (Map)this.copier);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard){

                protected void cancelPressed() {
                    super.cancelPressed();
                    this.setReturnCode(1);
                }

                protected void finishPressed() {
                    super.finishPressed();
                    TemplateParameterWizard w = wizard;
                    if (w.isKilled()) {
                        this.setReturnCode(1);
                    }
                }
            };
            if (dialog.open() == 1) {
                throw new ImportCancelledException();
            }
        }
    }

    private void embedTemplate(ModelType targetModel, DiagramType targetDiagram, int x, int y) {
        RootsType roots = this.template.getRoots();
        if (roots != null) {
            Collection refs = this.copyAll(this.getRoots((List)roots.getRoot()));
            refs = this.replacePredefinedTypes(targetModel, refs);
            refs = this.handleRoleTypes(targetModel, refs);
            for (Object root : refs) {
                if (root instanceof ProcessDefinitionType) {
                    this.embedProcessDefinition((ProcessDefinitionType)root, targetDiagram, x, y);
                    continue;
                }
                if (root instanceof TypeDeclarationType) {
                    targetModel.getTypeDeclarations().getTypeDeclaration().add((Object)((TypeDeclarationType)root));
                    continue;
                }
                if (root instanceof DataType) {
                    DataType dataType = (DataType)root;
                    DataTypeType dataTypeType = (DataTypeType)ModelUtils.findElementById((EObject)targetModel, (EStructuralFeature)PKG.getModelType_DataType(), (String)dataType.getType().getId());
                    dataType.setType(dataTypeType);
                    this.addObjectTo((EObject)targetModel, (EObject)((IModelElement)root));
                    continue;
                }
                if (!(root instanceof IModelElement)) continue;
                this.addObjectTo((EObject)targetModel, (EObject)((IModelElement)root));
            }
        }
    }

    private Collection replacePredefinedTypes(ModelType targetModel, Collection refs) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject object : refs) {
            EObject original;
            IIdentifiableElement identifiable;
            EStructuralFeature feature;
            if (object instanceof IIdentifiableElement && (feature = TemplateAdapter.getContainingFeature((EObject)targetModel, (EObject)(identifiable = (IIdentifiableElement)object))) != null && this.isReusable(identifiable) && (original = ModelUtils.findElementById((EObject)targetModel, (EStructuralFeature)feature, (String)identifiable.getId())) != null && original.eClass() == identifiable.eClass()) {
                MergeUtils.replace((EObject)identifiable, (EObject)original, (boolean)true);
                continue;
            }
            result.add(object);
        }
        return result;
    }

    private Collection handleRoleTypes(ModelType targetModel, Collection refs) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject object : refs) {
            if (object instanceof RoleType) {
                this.addObjectTo((EObject)targetModel, object);
            }
            result.add(object);
        }
        return result;
    }

    private boolean isReusable(IIdentifiableElement identifiable) {
        IDataType data;
        if (identifiable instanceof IMetaType) {
            return true;
        }
        if (identifiable instanceof IModelParticipant) {
            return true;
        }
        return identifiable instanceof IDataType && (data = (IDataType)identifiable).isPredefined();
    }

    public Collection copyAll(Collection eObjects) {
        this.copier = new EcoreUtil.Copier(){
            private static final long serialVersionUID = 1L;

            public EObject copy(EObject object) {
                if (object instanceof XSDSchema) {
                    XSDSchema original = (XSDSchema)object;
                    XSDSchema clone = (XSDSchema)original.cloneConcreteComponent(true, false);
                    Document doc = clone.updateDocument();
                    if (original.getElement() != null) {
                        Element clonedElement = (Element)doc.importNode(original.getElement(), true);
                        doc.appendChild(clonedElement);
                        clone.setElement(clonedElement);
                    }
                    return clone;
                }
                return super.copy(object);
            }
        };
        Collection result = this.copier.copyAll(eObjects);
        this.copier.copyReferences();
        return result;
    }

    private List getRoots(List roots) {
        ArrayList<Object> result = new ArrayList<Object>();
        TemplatesTypeImpl templates = (TemplatesTypeImpl)this.template.eContainer();
        TemplateLibraryType library = (TemplateLibraryType)templates.eContainer();
        result.add(library.getModel());
        int i = 0;
        while (i < roots.size()) {
            ReferenceType ref = (ReferenceType)roots.get(i);
            result.add(ref.getReference());
            ++i;
        }
        return result;
    }

    private void embedProcessDefinition(ProcessDefinitionType root, DiagramType targetDiagram, int x, int y) {
        EObject targetContainer = targetDiagram.eContainer();
        if (targetContainer instanceof ProcessDefinitionType) {
            ProcessDefinitionType targetProcessDefinition = (ProcessDefinitionType)targetContainer;
            targetProcessDefinition.getActivity().addAll((Collection)root.getActivity());
            targetProcessDefinition.getTransition().addAll((Collection)root.getTransition());
            EList diagrams = root.getDiagram();
            if (!diagrams.isEmpty()) {
                this.embedDiagram(targetDiagram, (DiagramType)diagrams.get(0), x, y);
            }
        } else {
            System.err.println(Templates_Messages.CSL_INCOMPATIBLE_CONTAINER);
        }
    }

    private void embedDiagram(DiagramType targetDiagram, DiagramType sourceDiagram, int x, int y) {
        DiagramType container = targetDiagram;
        if (this.editPart.getModel() != null && this.editPart.getModel() instanceof ISymbolContainer) {
            container = (ISymbolContainer)this.editPart.getModel();
            x = 0;
            y = 0;
        } else {
            EList pools = targetDiagram.getPoolSymbols();
            if (!pools.isEmpty()) {
                int i = 0;
                while (i < pools.size()) {
                    PoolSymbol pool = (PoolSymbol)pools.get(i);
                    if (this.contains(pool, x, y)) {
                        container = pool;
                        break;
                    }
                    ++i;
                }
            }
        }
        PoolSymbol sourcePool = (PoolSymbol)sourceDiagram.getPoolSymbols().get(0);
        ArrayList copy = new ArrayList();
        copy.addAll(sourcePool.eContents());
        int i = 0;
        while (i < copy.size()) {
            TransitionConnectionType tc;
            EObject object = (EObject)copy.get(i);
            if (object instanceof IModelElementNodeSymbol && object instanceof RoleSymbolType) {
                CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
                EObject eObject = ModelUtils.findElementById((EObject)this.targetModel, (EStructuralFeature)CWM_PKG.getModelType_Role(), (String)((RoleSymbolType)object).getModelElement().getId());
                ((IModelElementNodeSymbol)object).setModelElement((IIdentifiableModelElement)eObject);
            }
            this.addObjectTo((EObject)container, object);
            if (object instanceof INodeSymbol) {
                INodeSymbol symbol = (INodeSymbol)object;
                symbol.setXPos(symbol.getXPos() + (long)x);
                symbol.setYPos(symbol.getYPos() + (long)y);
            } else if (object instanceof TransitionConnectionType && RoutingType.EXPLICIT_LITERAL == (tc = (TransitionConnectionType)object).getRouting()) {
                EList coordinates = tc.getCoordinates();
                int j = 0;
                while (j < coordinates.size()) {
                    Coordinates coordinate = (Coordinates)coordinates.get(j);
                    coordinate.setXPos(coordinate.getXPos() + (double)x);
                    coordinate.setYPos(coordinate.getYPos() + (double)y);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addObjectTo(EObject container, EObject object) {
        EStructuralFeature feature = TemplateAdapter.getContainingFeature(container, object);
        if (feature != null) {
            if (feature.isMany()) {
                List list = (List)container.eGet(feature);
                list.add(object);
            } else {
                container.eSet(feature, (Object)object);
            }
        } else {
            System.err.println(MessageFormat.format(Templates_Messages.CSL_CONTAINMENT_FEATURE_NOT_FOUND_FOR, object));
        }
    }

    public static EStructuralFeature getContainingFeature(EObject container, EObject object) {
        EStructuralFeature feature = object.eContainingFeature();
        if (feature != null) {
            return feature;
        }
        EList containments = container.eClass().getEAllContainments();
        int i = 0;
        while (i < containments.size()) {
            feature = (EStructuralFeature)containments.get(i);
            if (feature.getEType().isInstance((Object)object)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    private boolean contains(PoolSymbol pool, int x, int y) {
        long px = pool.getXPos();
        if ((long)x < px) {
            return false;
        }
        long py = pool.getYPos();
        if ((long)y < py) {
            return false;
        }
        long w = pool.getWidth();
        if (w >= 0L && px + w < (long)x) {
            return false;
        }
        long h = pool.getHeight();
        return h < 0L || py + h >= (long)x;
    }

    @Override
    public ITemplateFactory getParentFactory() {
        return this.parentTemplateFactory;
    }
}

