/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.emf.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureStyleType implements Enumerator
{
    TEXT(0, "text", "text"),
    SELECTION(1, "selection", "selection");

    public static final int TEXT_VALUE = 0;
    public static final int SELECTION_VALUE = 1;
    private static final FeatureStyleType[] VALUES_ARRAY;
    public static final List<FeatureStyleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureStyleType[]{TEXT, SELECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureStyleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureStyleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureStyleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureStyleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureStyleType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return SELECTION;
            }
        }
        return null;
    }

    private FeatureStyleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

