/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;

public class Category {
    private String id;
    private String name;
    private Category parent;
    private List factories = new ArrayList();

    public Category(String id, String name, Category parent) {
        this.id = id;
        this.name = name;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Category getParent() {
        return this.parent;
    }

    public List getTemplates() {
        ArrayList<ITemplate> allTemplates = new ArrayList<ITemplate>();
        for (ITemplateFactory templateFactory : this.factories) {
            if (templateFactory.getTemplates() == null) continue;
            allTemplates.addAll(Arrays.asList(templateFactory.getTemplates()));
        }
        return allTemplates;
    }

    public List getFactories() {
        return this.factories;
    }

    public String toString() {
        if (this.name == null) {
            return this.id == null ? "" : this.id;
        }
        return this.name;
    }

    public Object[] getChildren() {
        List allChildren = this.getTemplates();
        HashMap<String, Category> categoryMap = new HashMap<String, Category>();
        for (ITemplateFactory factory : this.factories) {
            ITemplateFactory[] childFactories = factory.getChildFactories();
            if (childFactories == null) continue;
            int f = 0;
            while (f < childFactories.length) {
                ITemplateFactory childFactory = childFactories[f];
                Object object = categoryMap.get(childFactory.getId());
                Category category = null;
                if (object != null) {
                    category = (Category)object;
                } else {
                    category = new Category(childFactory.getId(), childFactory.getName(), null);
                    allChildren.add(category);
                    categoryMap.put(category.getId(), category);
                }
                category.getFactories().add(childFactory);
                ++f;
            }
        }
        return allChildren.toArray();
    }
}

