/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;
import org.eclipse.stardust.modeling.templates.views.Category;

public class PatternsContentProvider
implements ITreeContentProvider {
    private Object[] input;

    public Object[] getChildren(Object element) {
        if (element instanceof Category) {
            return ((Category)element).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Category) {
            return ((Category)element).getChildren().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.input;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        HashMap<String, Category> categoryMap = new HashMap<String, Category>();
        String extensionId = (String)newInput;
        ArrayList<Category> categories = new ArrayList<Category>();
        if (extensionId != null) {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement cfg = extensions[i];
                try {
                    String name = cfg.getName();
                    if ("factory".equals(name)) {
                        ITemplateFactory factory = (ITemplateFactory)cfg.createExecutableExtension("class");
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        IConfigurationElement[] children = extensions[i].getChildren("parameter");
                        int j = 0;
                        while (j < children.length) {
                            String cname = children[j].getAttribute("name");
                            String value = children[j].getAttribute("value");
                            parameters.put(cname, value);
                            ++j;
                        }
                        factory.initialize(parameters);
                        Object object = categoryMap.get(factory.getId());
                        Category category = null;
                        if (object != null) {
                            category = (Category)object;
                        } else {
                            category = new Category(factory.getId(), factory.getName(), null);
                            categories.add(category);
                            categoryMap.put(category.getId(), category);
                        }
                        category.getFactories().add(factory);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        this.input = categories.toArray();
    }
}

