/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageBreakpointManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MessageTypeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final Image primitiveImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/primitive_data.gif").createImage();
    private static final Image legoImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/lego_icon.gif").createImage();
    private static final Image primitiveBpImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/primitive_data_bp.png").createImage();
    private static final Image legoBpImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/lego_icon_bp.png").createImage();
    private static final Image errorImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error_tsk.gif").createImage();
    private static final Image serializableImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/serializable_data.gif").createImage();
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_MAPPING = 2;
    private static final int COLUMN_ERROR_IMAGE = 3;
    private FontRegistry fontRegistry = new FontRegistry();
    private MessageTransformationController controller;
    private final MessageBreakpointManager breakpointManager;
    private boolean showGroupInfo;

    public MessageTypeLabelProvider(MessageTransformationController controller) {
        this.controller = controller;
        this.breakpointManager = new MessageBreakpointManager();
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof AccessPointType) {
            boolean valid;
            FieldMapping fm;
            AccessPointType messageType;
            if (columnIndex == 0) {
                boolean breakpointAvailable;
                AccessPointType messageType2 = (AccessPointType)element;
                FieldMapping fm2 = this.controller.getFieldMappings().get(this.controller.getXPathFor(messageType2));
                boolean bl = breakpointAvailable = fm2 == null ? false : this.breakpointManager.isBreakpointAvailable(fm2.getFieldPath());
                if (this.controller.isSerializable(messageType2)) {
                    return breakpointAvailable ? legoBpImage : serializableImage;
                }
                if (this.controller.isRoot(messageType2) && this.controller.isSerializable(messageType2)) {
                    return breakpointAvailable ? legoBpImage : serializableImage;
                }
                if ((this.controller.isRoot(messageType2) || this.controller.isComplexType(messageType2)) & !this.controller.isPrimitive(messageType2)) {
                    return breakpointAvailable ? legoBpImage : legoImage;
                }
                return breakpointAvailable ? primitiveBpImage : primitiveImage;
            }
            if (!(3 != columnIndex || this.controller.isRoot(messageType = (AccessPointType)element) && !this.controller.isPrimitive(messageType) || (fm = this.controller.getFieldMappings().get(this.controller.getXPathFor(messageType))) == null || (valid = this.controller.validateMapping(fm, false)))) {
                return errorImage;
            }
        }
        return null;
    }

    private String parseName(String path) {
        if (path.startsWith("typeDeclaration:")) {
            path = path.replaceAll("typeDeclaration:", "");
            path = path.replace("{", "");
            path = path.replace("}", " / ");
        }
        return path;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof AccessPointType) {
                    AccessPointType messageType = (AccessPointType)element;
                    String displayString = messageType.getId();
                    if (displayString.startsWith("@")) {
                        displayString = displayString.length() == 1 ? "<value>" : displayString.replace("@", "");
                    }
                    return displayString;
                }
            }
            case 1: {
                AttributeType attType;
                AccessPointType messageElement = (AccessPointType)element;
                String typeString = this.controller.getTypeString(messageElement);
                if (this.controller.isList(messageElement)) {
                    typeString = String.valueOf(typeString) + "*";
                    typeString = typeString.replace("null", "");
                }
                if (this.showGroupInfo && (attType = AttributeUtil.getAttribute((IExtensibleElement)messageElement, (String)"carnot:engine:dataType")) != null) {
                    String path = AttributeUtil.getAttribute((IExtensibleElement)messageElement, (String)"carnot:engine:dataType").getValue();
                    typeString = this.parseName(path);
                }
                return typeString;
            }
            case 2: {
                if (!(element instanceof AccessPointType)) break;
                AccessPointType messageType = (AccessPointType)element;
                String xPath = this.controller.getXPathFor(messageType);
                FieldMapping fieldMapping = this.controller.getFieldMappings().get(xPath);
                if (fieldMapping == null || fieldMapping.getMappingExpression() == null) break;
                String text = fieldMapping.getMappingExpression();
                text = text.replace('\n', ' ');
                return text;
            }
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        Font font = Display.getCurrent().getSystemFont();
        if (element instanceof AccessPointType) {
            AccessPointType messageType = (AccessPointType)element;
            if (!this.controller.isSourceField(messageType)) {
                if ((this.controller.hasMappingExpression(element) || this.controller.hasMappingStatement(element)) && columnIndex == 0) {
                    font = this.fontRegistry.getItalic(Display.getCurrent().getSystemFont().getFontData()[0].getName());
                }
                if (this.controller.containsSelectedSourceField(element)) {
                    font = this.fontRegistry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
                }
            } else if (this.controller.isContainedInSelectedTargetField(element)) {
                font = this.fontRegistry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
            }
        }
        return font;
    }

    public void setShowGroupInfo(boolean showGroupInfo) {
        this.showGroupInfo = showGroupInfo;
    }
}

