/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.engine.core.struct.spi.StructDataTransformerKey;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkspaceManager;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.BridgeObjectProviderRegistry;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DataMappingValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        DataMappingType dataMapping = (DataMappingType)element;
        if (StringUtils.isEmpty((String)dataMapping.getId())) {
            result.add(Issue.error((EObject)dataMapping, (String)Validation_Messages.ERR_ELEMENT_EmptyId, (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (StringUtils.isEmpty((String)dataMapping.getName())) {
            result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_ELEMENT_EmptyName, (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        }
        this.checkActivitySupportsDataMapppings(result, dataMapping);
        this.checkDuplicateIds(result, dataMapping);
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        this.checkData(result, dataMapping);
        ApplicationContextTypeType ctxType = this.checkContext(result, dataMapping);
        if (!StringUtils.isEmpty((String)dataMapping.getApplicationAccessPoint())) {
            this.checkAccessPoint(result, dataMapping, ctxType);
        } else {
            IBridgeObjectProvider dataBridgeProvider;
            if (ctxType.isHasApplicationPath()) {
                result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoApplicationAccessPointSet, (Object)ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint()));
            } else if (ActivityUtil.isRouteActivity((ActivityType)activity)) {
                result.add(Issue.warning((EObject)dataMapping, (String)(DirectionType.OUT_LITERAL.equals((Object)dataMapping.getDirection()) ? Validation_Messages.WR_MAPPING_NO_IN_DATA_MAPPING_SPECIFIED : Validation_Messages.WR_MAPPING_INCONSISTENT_DATA_MAPPING_ID), (Object)ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint()));
            }
            IBridgeObjectProvider iBridgeObjectProvider = dataBridgeProvider = dataMapping.getData() != null ? BridgeObjectProviderRegistry.getBridgeObjectProvider((ITypedElement)dataMapping.getData()) : null;
            if (dataBridgeProvider != null) {
                try {
                    String dataPath = dataMapping.getDataPath();
                    if (dataPath != null) {
                        dataPath = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer().eContainer()).replaceAllVariablesByDefaultValue(dataPath);
                    }
                    dataBridgeProvider.getBridgeObject((ITypedElement)dataMapping.getData(), dataPath, DirectionType.OUT_LITERAL.equals((Object)dataMapping.getDirection()) ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL);
                    this.checkValidXPath(dataMapping);
                }
                catch (Exception exception) {
                    if ("struct".equals(dataMapping.getData().getMetaType().getId())) {
                        this.checkValidXPath(dataMapping);
                    }
                    result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)ValidationService.PKG_CWM.getDataMappingType_DataPath()));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkValidXPath(DataMappingType dataMapping) {
        String dataPath;
        DataType data = dataMapping.getData();
        if (data.eIsProxy()) {
            data = (DataType)WorkspaceManager.getInstance().findElement((EObject)data);
        }
        if ("struct".equals(data.getMetaType().getId()) && !StringUtils.isEmpty((String)(dataPath = dataMapping.getDataPath()))) {
            StructDataTransformerKey transformerKey;
            int ix;
            if (dataPath.charAt(dataPath.length() - 1) == ')' && (ix = dataPath.indexOf(40)) > 0 && (transformerKey = StructDataTransformerKey.getKey((String)dataPath.substring(0, ix))) != null) {
                dataPath = dataPath.substring(ix + 1, dataPath.length() - 1);
            }
            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((DataType)data);
            if (dataPath.indexOf("[") > -1) {
                this.checkNestedPath(dataPath, xPathMap);
            } else if (!xPathMap.containsXPath(dataPath)) {
                int ix2 = dataPath.lastIndexOf(47);
                while (ix2 >= 0) {
                    if (!xPathMap.containsXPath(dataPath = dataPath.substring(0, ix2)) || !xPathMap.getXPath(dataPath).hasWildcards()) continue;
                    return;
                }
                throw new ValidationException(Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)dataPath);
            }
        }
    }

    private void checkNestedPath(String dataPath, IXPathMap xPathMap) {
        String[] pathSegs = dataPath.split("/");
        String path = "";
        int i = 0;
        while (i < pathSegs.length) {
            TypedXPath xPath;
            path = String.valueOf(path) + pathSegs[i];
            if (!xPathMap.containsXPath(path = path.replaceAll("\\[[^\\]]*\\]|\\..*/", ""))) {
                throw new ValidationException(Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)dataPath);
            }
            if (pathSegs[i].indexOf("[") > -1 && !(xPath = xPathMap.getXPath(path)).isList()) {
                throw new ValidationException(Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)dataPath);
            }
            if (i < pathSegs.length) {
                path = String.valueOf(path) + "/";
            }
            ++i;
        }
    }

    private void checkAccessPoint(List<Issue> result, DataMappingType dataMapping, ApplicationContextTypeType ctxType) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        if (ctxType != null && "default".equalsIgnoreCase(ctxType.getId()) && ActivityUtil.isRouteActivity((ActivityType)activity)) {
            if (DirectionType.OUT_LITERAL.equals((Object)dataMapping.getDirection())) {
                this.checkCorrespondingInDataMapping(result, dataMapping);
            } else if (!CompareHelper.areEqual((Object)dataMapping.getId(), (Object)dataMapping.getApplicationAccessPoint())) {
                result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.WR_MAPPING_INCONSISTENT_DATA_MAPPING_ID, (Object)ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint()));
            }
            try {
                this.checkValidXPath(dataMapping);
            }
            catch (Exception exception) {
                result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)ValidationService.PKG_CWM.getDataMappingType_DataPath()));
            }
        } else if (ctxType != null && dataMapping.getData() != null) {
            AccessPointType point = this.getActivityAccessPoint(dataMapping);
            if (point == null) {
                result.add(Issue.warning((EObject)dataMapping, (String)MessageFormat.format(Validation_Messages.MSG_DATAMAPPING_ApplicationAccessPointWarning, dataMapping.getId()), (Object)ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint()));
            } else {
                try {
                    if (AccessPointUtil.isIn((DirectionType)dataMapping.getDirection())) {
                        BridgeObject.checkMapping((ITypedElement)point, dataMapping.getApplicationPath(), (ITypedElement)dataMapping.getData(), dataMapping.getDataPath(), activity, dataMapping);
                    } else {
                        BridgeObject.checkMapping((ITypedElement)dataMapping.getData(), dataMapping.getDataPath(), (ITypedElement)point, dataMapping.getApplicationPath(), activity, dataMapping);
                    }
                    try {
                        this.checkValidXPath(dataMapping);
                    }
                    catch (Exception exception) {
                        result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoValidDataPath, (Object)ValidationService.PKG_CWM.getDataMappingType_DataPath()));
                    }
                }
                catch (ValidationException e) {
                    result.add(Issue.warning((EObject)dataMapping, (String)e.getMessage(), (Object)this.getFeature(dataMapping, e.getSource())));
                }
            }
        }
    }

    private void checkCorrespondingInDataMapping(List<Issue> result, DataMappingType dataMapping) {
        DataMappingType inMapping = this.findCorrespondingInDataMapping(dataMapping);
        if (inMapping == null) {
            result.add(Issue.warning((EObject)dataMapping, (String)MessageFormat.format(Validation_Messages.WR_MAPPING_NO_IN_DATA_MAPPING_WITH_ID_STELLE_NULL_FOUND, dataMapping.getApplicationAccessPoint()), (Object)ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint()));
        } else if (dataMapping.getData() != null && inMapping.getData() != null) {
            try {
                ActivityType activity = (ActivityType)dataMapping.eContainer();
                BridgeObject.checkMapping((ITypedElement)dataMapping.getData(), dataMapping.getDataPath(), (ITypedElement)inMapping.getData(), inMapping.getDataPath(), activity);
                this.checkValidXPath(dataMapping);
            }
            catch (ValidationException e) {
                if ("struct".equals(dataMapping.getData().getMetaType().getId())) {
                    this.checkValidXPath(dataMapping);
                }
                result.add(Issue.warning((EObject)dataMapping, (String)e.getMessage(), (Object)ValidationService.PKG_CWM.getDataMappingType_DataPath()));
            }
        }
    }

    private DataMappingType findCorrespondingInDataMapping(DataMappingType dataMapping) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        EList mappings = activity.getDataMapping();
        for (DataMappingType inMapping : mappings) {
            if (!DirectionType.IN_LITERAL.equals((Object)inMapping.getDirection()) || !dataMapping.getContext().equalsIgnoreCase(inMapping.getContext()) || !dataMapping.getApplicationAccessPoint().equalsIgnoreCase(inMapping.getApplicationAccessPoint())) continue;
            return inMapping;
        }
        return null;
    }

    private ApplicationContextTypeType checkContext(List<Issue> result, DataMappingType dataMapping) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        ApplicationContextTypeType ctxType = null;
        if (StringUtils.isEmpty((String)dataMapping.getContext())) {
            result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoContextSet, (Object)ValidationService.PKG_CWM.getDataMappingType_Context()));
        } else {
            ctxType = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((List)ActivityUtil.getContextTypes((ActivityType)activity, (DirectionType)dataMapping.getDirection()), (String)dataMapping.getContext());
            if (ctxType == null) {
                result.add(Issue.warning((EObject)dataMapping, (String)MessageFormat.format(Validation_Messages.MSG_DATAMAPPING_ContextInvalid, dataMapping.getContext()), (Object)ValidationService.PKG_CWM.getDataMappingType_Context()));
            }
        }
        return ctxType;
    }

    private void checkData(List<Issue> result, DataMappingType dataMapping) {
        if (dataMapping.getData() == null && dataMapping.getDataPath() == null) {
            result.add(Issue.error((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NoDataSet, (Object)ValidationService.PKG_CWM.getDataMappingType_Data()));
        }
    }

    private void checkDuplicateIds(List<Issue> result, DataMappingType dataMapping) {
        if (this.findDuplicateId(dataMapping)) {
            result.add(Issue.warning((EObject)dataMapping, (String)MessageFormat.format(Validation_Messages.MSG_DATAMAPPING_NoUniqueId, dataMapping.getDirection().getName()), (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
    }

    private void checkActivitySupportsDataMapppings(List<Issue> result, DataMappingType dataMapping) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        if (ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)activity.getImplementation()) && activity.getSubProcessMode() == SubProcessModeType.ASYNC_SEPARATE_LITERAL && DirectionType.IN_LITERAL != dataMapping.getDirection()) {
            result.add(Issue.warning((EObject)dataMapping, (String)Validation_Messages.MSG_DATAMAPPING_NotSupportedByActivity, (Object)ValidationService.PKG_CWM.getActivityType_DataMapping()));
        }
    }

    private EStructuralFeature getFeature(DataMappingType dataMapping, Object source) {
        if (source != null) {
            if (source.equals(dataMapping.getData())) {
                return ValidationService.PKG_CWM.getDataMappingType_Data();
            }
            if (source.equals(dataMapping.getDataPath())) {
                return ValidationService.PKG_CWM.getDataMappingType_DataPath();
            }
            if (source instanceof AccessPointType && ((AccessPointType)source).getId().equals(dataMapping.getApplicationAccessPoint())) {
                return ValidationService.PKG_CWM.getDataMappingType_ApplicationAccessPoint();
            }
            if (source.equals(dataMapping.getApplicationPath())) {
                return ValidationService.PKG_CWM.getDataMappingType_ApplicationPath();
            }
        }
        return null;
    }

    private AccessPointType getActivityAccessPoint(DataMappingType dataMapping) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        List accessPoints = ActivityUtil.getAccessPoints((ActivityType)activity, (boolean)DirectionType.IN_LITERAL.equals((Object)dataMapping.getDirection()), (String)dataMapping.getContext());
        for (AccessPointType ap : accessPoints) {
            if (!ap.getId().equals(dataMapping.getApplicationAccessPoint())) continue;
            return ap;
        }
        return null;
    }

    private boolean findDuplicateId(DataMappingType dataMapping) {
        ActivityType activity = (ActivityType)dataMapping.eContainer();
        for (DataMappingType otherDataMapping : activity.getDataMapping()) {
            if (!CompareHelper.areEqual((Object)dataMapping.getId(), (Object)otherDataMapping.getId()) || !CompareHelper.areEqual((Object)dataMapping.getContext(), (Object)otherDataMapping.getContext()) || dataMapping.equals(otherDataMapping) || !dataMapping.getDirection().equals((Object)otherDataMapping.getDirection()) || dataMapping.getContext() == null || otherDataMapping.getContext() == null) continue;
            return true;
        }
        return false;
    }
}

