/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.applicationTypes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class PlainJavaValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        TypeFinder typeFinder = new TypeFinder((EObject)element);
        TypeInfo type = null;
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
        VariableContext variableContext = VariableContextHelper.getInstance().getContext(element);
        className = variableContext.replaceAllVariablesByDefaultValue(className);
        if (StringUtils.isEmpty((String)className)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_JavaClassNotSpecified, (Object)"carnot:engine:className"));
        } else {
            type = typeFinder.findType(className);
            if (type == null) {
                result.add(Issue.error((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)"carnot:engine:className"));
            }
        }
        String constructorName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:constructorName");
        constructorName = variableContext.replaceAllVariablesByDefaultValue(constructorName);
        if (StringUtils.isEmpty((String)constructorName)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_ConstructorNotSpecified, (Object)"carnot:engine:constructorName"));
        } else if (type != null) {
            MethodInfo constructor = typeFinder.getConstructor(type, constructorName);
            if (constructor == null) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_CouldntFindConstructor, constructorName, type.getType().getElementName()), (Object)"carnot:engine:constructorName"));
            } else if (!constructor.isAccessible()) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_ConstructorNotVisible, constructorName, type.getType().getElementName()), (Object)"carnot:engine:constructorName"));
            }
        }
        String method = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
        method = variableContext.replaceAllVariablesByDefaultValue(method);
        if (StringUtils.isEmpty((String)method)) {
            result.add(Issue.warning((EObject)element, (String)Validation_Messages.MSG_CompletionMethodNotSpecified, (Object)"carnot:engine:methodName"));
        } else if (type != null) {
            MethodInfo info = typeFinder.getMethod(type, method);
            if (info == null) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, type.getType().getElementName()), (Object)"carnot:engine:methodName"));
            } else if (!info.isAccessible()) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(Validation_Messages.MSG_MethodNotVisible, method, type.getType().getElementName()), (Object)"carnot:engine:methodName"));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

