/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.PathEntry;

public class Path {
    private List<PathEntry> segments = new ArrayList<PathEntry>();
    private String label;
    private String type;
    private int selection;
    private int selectionStart;
    private int selectionLength;
    private boolean matchesDirection;

    public Path(PathEntry root) {
        this.segments.add(root);
        this.label = this.computeLabel(0);
        this.computeType();
        this.setSelection(root);
    }

    public boolean matchesDirection() {
        return this.matchesDirection;
    }

    public void setMethod(String method) {
        if (method.length() > 0) {
            int ix;
            PathEntry entry = this.segments.get(this.selection);
            IAccessPathEditor editor = entry.getAccessPathEditor();
            String[] splited = editor.splitAccessPath(method);
            String simpleName = splited[0];
            long index = -1L;
            if (splited[0].endsWith(entry.getIndexEnd()) && (ix = splited[0].lastIndexOf(entry.getIndexStart())) > 0) {
                simpleName = splited[0].substring(0, ix);
                String indexString = splited[0].substring(ix + entry.getIndexStart().length(), splited[0].length() - entry.getIndexEnd().length());
                try {
                    index = Long.parseLong(indexString);
                }
                catch (Exception exception) {}
            }
            boolean found = false;
            List<PathEntry> children = entry.getChildren();
            for (PathEntry child : children) {
                if (!simpleName.equals(child.getId())) continue;
                found = true;
                this.push(child);
                if (this.isIndexed()) {
                    this.setIndex(index);
                }
                if (splited[1] == null) break;
                this.setMethod(splited[1].trim());
                break;
            }
            if (!found) {
                PathEntry root = this.segments.get(0);
                throw new ValidationException(MessageFormat.format(Validation_Messages.Path_InvalidSegment, simpleName), (Object)root.getElement());
            }
        }
    }

    public String getMethod() {
        return this.computeLabel(1);
    }

    public List<PathEntry> getChildren() {
        return this.segments.get(this.selection).getChildren();
    }

    public boolean isSingle() {
        return this.segments.get(this.selection).isSingle();
    }

    public boolean isIndexed() {
        return this.segments.get(this.selection).isIndexed();
    }

    public long getIndex() {
        return this.segments.get(this.selection).getIndex();
    }

    public void setIndex(long index) {
        PathEntry entry = this.segments.get(this.selection);
        entry.setIndex(index);
        if (!entry.isSingle() && entry.isIn()) {
            int i = this.segments.size() - 1;
            while (i > this.selection) {
                this.segments.remove(i);
                --i;
            }
            this.computeType();
        }
        this.updateSelection();
    }

    public String getType() {
        return this.type;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRootSelected() {
        return this.selection == 0;
    }

    public PathEntry selectPathEntry(int offset) {
        PathEntry entry = null;
        int pos = 0;
        int i = 0;
        while (i < this.segments.size()) {
            entry = this.segments.get(i);
            int len = entry.getFullId().length();
            if (offset >= pos && offset <= pos + len) break;
            pos += len;
            if (i < this.segments.size() - 1) {
                pos += entry.getSeparator().length();
            }
            ++i;
        }
        this.setSelection(entry);
        return this.selection < this.segments.size() - 1 ? this.segments.get(this.selection + 1) : null;
    }

    public PathEntry pop() {
        --this.selection;
        this.updateSelection();
        return this.segments.get(this.selection + 1);
    }

    public PathEntry push(PathEntry entry) {
        ++this.selection;
        if (this.selection < this.segments.size()) {
            if (!entry.equals(this.segments.get(this.selection))) {
                int i = this.segments.size() - 1;
                while (i > this.selection) {
                    this.segments.remove(i);
                    --i;
                }
                this.segments.set(this.selection, entry);
            }
        } else {
            this.segments.add(entry);
        }
        this.updateSelection();
        return this.selection < this.segments.size() - 1 ? this.segments.get(this.selection + 1) : null;
    }

    private void computeType() {
        int dimension = 0;
        PathEntry entry = null;
        int i = 0;
        while (i < this.segments.size()) {
            entry = this.segments.get(i);
            if (!entry.isSingle()) {
                ++dimension;
            }
            ++i;
        }
        this.type = entry.getTypeName(dimension);
        this.matchesDirection = entry.matchesDirection();
    }

    private String computeLabel(int start) {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < this.segments.size()) {
            PathEntry entry = this.segments.get(i);
            sb.append(entry.getFullId());
            if (i < this.segments.size() - 1) {
                sb.append(entry.getSeparator());
            }
            ++i;
        }
        return sb.toString();
    }

    private void setSelection(PathEntry entry) {
        this.selection = this.segments.indexOf(entry);
        if (this.selection < 0) {
            this.segments.clear();
            this.segments.add(entry);
            this.selection = 0;
        }
        this.updateSelection();
    }

    private void updateSelection() {
        this.label = this.computeLabel(0);
        this.computeType();
        this.selectionStart = 0;
        int i = 0;
        while (i < this.selection) {
            PathEntry pe = this.segments.get(i);
            this.selectionStart += pe.getFullId().length();
            this.selectionStart += pe.getSeparator().length();
            ++i;
        }
        PathEntry entry = this.segments.get(this.selection);
        this.selectionLength = entry.getFullId().length();
    }

    public PathEntry getSelection() {
        return this.segments.get(this.selection);
    }

    public boolean isLastItem() {
        return this.selection == this.segments.size() - 1;
    }

    public void cut() {
        int i = this.segments.size() - 1;
        while (i > this.selection) {
            this.segments.remove(i);
            --i;
        }
        this.updateSelection();
    }
}

