/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionIntegerGenerator;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.swt.widgets.Composite;

public class NormalDistributionIntegerGeneratorPanel
extends NormalDistributionDataGeneratorPanel {
    private static final String[] multiplicatorSuggestions = new String[]{"1", "10", "100", "1000", "100000", "1000000"};
    private static final NumberFormat formatter = new DecimalFormat(" #,###,###");
    LabeledCombo multiplicator;

    protected NormalDistributionIntegerGeneratorPanel(Composite parent, NormalDistributionIntegerGenerator configuration) {
        super(parent, configuration);
    }

    @Override
    protected void initAdditionalControls() {
        this.multiplicator = FormBuilder.createLabeledCombo((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.DATA_VALUE_GENERATOR_MULTIPLICATOR);
        this.multiplicator.getCombo().setItems(multiplicatorSuggestions);
        int i = 0;
        while (i < multiplicatorSuggestions.length) {
            String formatted = formatter.format(Double.parseDouble(multiplicatorSuggestions[i]));
            this.multiplicator.getCombo().setItem(i, formatted);
            ++i;
        }
        String selection = this.configuration.getOption("multiplicator");
        int selectionIndex = Arrays.asList(multiplicatorSuggestions).indexOf(selection);
        this.multiplicator.getCombo().select(selectionIndex > 0 ? selectionIndex : 0);
    }

    @Override
    protected void syncUiToModel() {
        int selectionIndex = this.multiplicator.getCombo().getSelectionIndex();
        this.configuration.getOptions().put("multiplicator", multiplicatorSuggestions[selectionIndex > 0 ? selectionIndex : 0]);
        super.syncUiToModel();
    }
}

