/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.slider.gui;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.ide.simulation.ui.slider.SimSlider;
import org.eclipse.stardust.ide.simulation.ui.slider.gui.SliderFinder;
import org.eclipse.stardust.ide.simulation.ui.slider.gui.WorkflowEditorExtendedView;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationNotification;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowPropertiesAction;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SliderView
extends WorkflowEditorExtendedView {
    public static final String ID = "org.eclipse.stardust.ide.simulation.ui.runtime.gui.SliderView";
    private Composite parent;
    private SliderWidgets[] scaleWidgets;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initializePageEventDispatcher();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    private void updateSliderList(SimSlider[] slider) {
        if (this.parent.getChildren().length > 0) {
            this.parent.getChildren()[0].dispose();
        }
        Composite mainPanel = FormBuilder.createComposite((Composite)this.parent, (int)1);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(3, 0).numColumns(4).applyTo(mainPanel);
        this.scaleWidgets = new SliderWidgets[slider.length];
        int i = 0;
        while (i < slider.length) {
            this.scaleWidgets[i] = new SliderWidgets();
            this.scaleWidgets[i].config = slider[i];
            this.scaleWidgets[i].label = new Hyperlink(mainPanel, 0x804080);
            this.scaleWidgets[i].label.setText(slider[i].getLabel());
            this.scaleWidgets[i].label.setUnderlined(true);
            this.scaleWidgets[i].scale = new Scale(mainPanel, 0x1000100);
            this.scaleWidgets[i].scale.setSelection(slider[i].getValue());
            this.scaleWidgets[i].scale.setMaximum(slider[i].getMaxValue());
            this.scaleWidgets[i].scale.setMinimum(slider[i].getMinValue());
            this.scaleWidgets[i].scale.setIncrement(slider[i].getIncrement());
            this.scaleWidgets[i].scale.setPageIncrement(slider[i].getIncrement());
            this.scaleWidgets[i].valueText = FormBuilder.createText((Composite)mainPanel);
            this.scaleWidgets[i].valueText.setText(slider[i].getValueText());
            this.scaleWidgets[i].valueText.setEditable(false);
            this.scaleWidgets[i].deleteButton = new ImageHyperlink(mainPanel, 0x1800080);
            this.scaleWidgets[i].deleteButton.setImage(ImageDescriptor.createFromFile(SliderView.class, (String)"icons/delete.gif").createImage());
            SliderValueSelectionListener svsl = new SliderValueSelectionListener(this.scaleWidgets[i]);
            this.scaleWidgets[i].scale.addSelectionListener((SelectionListener)svsl);
            this.scaleWidgets[i].scale.addMouseListener((MouseListener)svsl);
            this.scaleWidgets[i].label.addHyperlinkListener((IHyperlinkListener)new EditButtonListener(this.scaleWidgets[i]));
            this.scaleWidgets[i].deleteButton.addHyperlinkListener((IHyperlinkListener)new DeleteButtonListener(this.scaleWidgets[i]));
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.scaleWidgets[i].label);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.scaleWidgets[i].scale);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(50, -1).applyTo((Control)this.scaleWidgets[i].valueText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.scaleWidgets[i].deleteButton);
            ++i;
        }
        this.parent.layout();
        this.parent.redraw();
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    @Override
    protected void updateOnSelectionChange(boolean editorChanged) {
        ModelType model = this.getCurrentEditor().getWorkflowModel();
        SimSlider[] slider = new SliderFinder().findSlider(model);
        this.updateSliderList(slider);
    }

    protected class DeleteButtonListener
    extends HyperlinkAdapter {
        SliderWidgets widgets;

        public DeleteButtonListener(SliderWidgets widgets) {
            this.widgets = widgets;
        }

        public void linkActivated(HyperlinkEvent e) {
            CommandStack commandStack = (CommandStack)SliderView.this.getCurrentEditor().getAdapter(CommandStack.class);
            commandStack.execute(this.widgets.config.createDeleteCommand());
            SliderView.this.getCurrentEditor().getWorkflowModel().eNotify((Notification)new SimulationNotification(1, true, false, (Object)this));
        }
    }

    protected class EditButtonListener
    extends HyperlinkAdapter {
        SliderWidgets widgets;

        public EditButtonListener(SliderWidgets widgets) {
            this.widgets = widgets;
        }

        public void linkActivated(HyperlinkEvent e) {
            SliderView.this.getCurrentEditor().selectInOutline((EObject)this.widgets.config.getModelObject());
            ContentOutlinePage outline = (ContentOutlinePage)SliderView.this.getCurrentEditor().getAdapter(IContentOutlinePage.class);
            ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction(SliderView.this.getCurrentEditor(), outline.getSite().getSelectionProvider());
            showPropertiesAction.run();
        }
    }

    protected static class SliderCommand
    extends Command {
        SimSlider config;
        int oldValue;

        protected SliderCommand() {
        }
    }

    protected class SliderValueSelectionListener
    extends MouseAdapter
    implements SelectionListener {
        SliderWidgets widgets;

        public SliderValueSelectionListener(SliderWidgets widgets) {
            this.widgets = widgets;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgets.config.setValue(this.widgets.scale.getSelection());
            this.widgets.valueText.setText(this.widgets.config.getValueText());
        }

        public void mouseUp(MouseEvent e) {
            this.widgets.config.setValue(this.widgets.scale.getSelection());
            this.widgets.valueText.setText(this.widgets.config.getValueText());
            if (this.widgets.config.isModified()) {
                CommandStack commandStack = (CommandStack)SliderView.this.getCurrentEditor().getAdapter(CommandStack.class);
                commandStack.execute(this.widgets.config.createCommitCommand());
            }
        }
    }

    protected static class SliderWidgets {
        SimSlider config;
        Hyperlink label;
        Scale scale;
        Text valueText;
        ImageHyperlink deleteButton;

        protected SliderWidgets() {
        }
    }
}

