/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationNotification;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class SimulationModelUtils {
    public static double calculateDefaultProbability(IModelElement transitionElement) {
        ProcessDefinitionType processDefinitionType = ModelUtils.findContainingProcess((EObject)transitionElement);
        for (ActivityType activityType : processDefinitionType.getActivity()) {
            if (!activityType.getOutTransitions().contains((Object)transitionElement)) continue;
            if (activityType.getSplit().equals((Object)JoinSplitType.XOR_LITERAL)) {
                return 100.0 / (double)activityType.getOutTransitions().size();
            }
            return 100.0;
        }
        throw new RuntimeException("could not find parent activity for transition <" + transitionElement + ">, inconsistent model?");
    }

    public static void fireNotificationEvent(EObject element, Object notifier) {
        try {
            ModelUtils.findContainingModel((EObject)element).eNotify((Notification)new SimulationNotification(1, element, element, notifier));
        }
        catch (RuntimeException e) {
            SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, Simulation_Modeling_Messages.ERROR_NOTIFICATION_FAILED, (Throwable)e));
        }
    }
}

