/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.stardust.ide.wst.common.utils.VariableUtils;


public class IPPPortalLibsVariableResolver extends ClasspathVariableInitializer
      implements IDynamicVariableResolver
{
   public void initialize(String variable)
   {
      if (IPPPortalBundleActivator.VAR_STARDUST_PORTAL_LIBS.equals(variable))
      {
         VariableUtils.initializeClasspathVariableFromBundleRoot(variable,
               IPPPortalBundleActivator.getInstance().getBundle());
      }
   }

   public String resolveValue(IDynamicVariable variable, String argument)
         throws CoreException
   {
      if (IPPPortalBundleActivator.VAR_STARDUST_PORTAL_LIBS.equals(variable.getName()))
      {
         return VariableUtils.resolveDynamicVariableFromBundleRoot(variable,
               IPPPortalBundleActivator.getInstance().getBundle());
      }
      return ""; //$NON-NLS-1$
   }
}