/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.actions;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.wizard.JSFGuiGenerationWizard;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.actions.AbstractUndoableAction;
import org.eclipse.stardust.modeling.core.actions.IGraphicalViewerAwareAction;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ConvertToJSFActivityAction
extends AbstractUndoableAction
implements IGraphicalViewerAwareAction {
    private GraphicalViewer graphicalViewer;

    public ConvertToJSFActivityAction() {
        this.setId(ConvertToJSFActivityAction.class.getName());
        this.setText(JSF_Messages.ConvertToJSFActivityAction_Text);
    }

    public void setGraphicalViewer(IWorkbenchPart workbenchPart, GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public boolean isEnabled() {
        ActivityType activity = this.getSelectedActivity();
        if (activity != null) {
            return super.isEnabled() && activity != null && ActivityImplementationType.MANUAL_LITERAL.equals((Object)activity.getImplementation());
        }
        return false;
    }

    protected Command doRunCommand() {
        CompoundCommand cmd = null;
        int returnCode = 1;
        ActivityType activity = this.getSelectedActivity();
        if (activity != null) {
            ActivitySymbolType symbol = this.getSelectedActivitySymbol(activity);
            if (this.isValidChange(activity)) {
                DiagramType diagram;
                PoolSymbol pool;
                Object container;
                WorkflowModelEditor editor;
                EditPart targetEditPart;
                Map registry = null;
                if (this.graphicalViewer != null) {
                    registry = this.graphicalViewer.getEditPartRegistry();
                }
                JSFGuiGenerationWizard jsfWizard = new JSFGuiGenerationWizard(activity, symbol, registry);
                WizardDialog w = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)jsfWizard);
                w.setBlockOnOpen(true);
                w.open();
                returnCode = w.getReturnCode();
                if (returnCode == 0 && symbol != null && (targetEditPart = (editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).findEditPart(container = (pool = DiagramUtil.getDefaultPool((DiagramType)(diagram = ModelUtils.findContainingDiagram((IGraphicalObject)symbol)))) == null ? diagram : (ISymbolContainer)symbol.eContainer())) instanceof AbstractSwimlaneEditPart) {
                    cmd = new CompoundCommand();
                    cmd.add((Command)new DelegatingCommand(){

                        public Command createDelegate() {
                            return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)((AbstractSwimlaneEditPart)targetEditPart));
                        }
                    });
                    cmd.add((Command)new DelegatingCommand(){

                        public Command createDelegate() {
                            return PoolLaneUtils.reorderSiblings((EditPart)targetEditPart, null);
                        }
                    });
                }
            }
        }
        return cmd;
    }

    private boolean isValidChange(ActivityType activity) {
        try {
            this.checkSourceFolders();
            AST ast = AST.newAST((int)3);
            this.checkInvalidIdentifiers(ast, activity);
            this.checkDuplicateidentifiers(activity);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.graphicalViewer.getControl().getShell(), (String)JSF_Messages.DIA_ERROR_ERROR, (String)JSF_Messages.DIA_ERROR_CANNOT_CONVERT_ACTIVITY, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private void checkDuplicateidentifiers(ActivityType activity) throws CoreException {
        Map inMappings = CollectionUtils.newMap();
        Set inCapitalizedIds = CollectionUtils.newSet();
        Map outMappings = CollectionUtils.newMap();
        Set outCapitalizedIds = CollectionUtils.newSet();
        for (DataMappingType dm : activity.getDataMapping()) {
            if (!"default".equals(dm.getContext())) continue;
            String id = this.getId(dm);
            String capitalizedId = this.capitalize(id);
            DirectionType direction = dm.getDirection();
            if (DirectionType.IN_LITERAL.equals((Object)direction) || DirectionType.INOUT_LITERAL.equals((Object)direction)) {
                if (inCapitalizedIds.contains(capitalizedId)) {
                    DataMappingType other = (DataMappingType)inMappings.get(capitalizedId);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Data_Mapping_has_similar_id_with_data_mapping, String.valueOf(dm.getElementOid()), id, String.valueOf(other.getElementOid()), this.getId(other)), null));
                }
                inCapitalizedIds.add(capitalizedId);
                inMappings.put(capitalizedId, dm);
            }
            if (!DirectionType.OUT_LITERAL.equals((Object)direction) && !DirectionType.INOUT_LITERAL.equals((Object)direction)) continue;
            if (outCapitalizedIds.contains(capitalizedId)) {
                DataMappingType other = (DataMappingType)outMappings.get(capitalizedId);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Data_Mapping_has_similar_id_with_data_mapping, String.valueOf(dm.getElementOid()), id, String.valueOf(other.getElementOid()), this.getId(other)), null));
            }
            outCapitalizedIds.add(capitalizedId);
            outMappings.put(capitalizedId, dm);
        }
    }

    private String capitalize(String id) {
        if (id == null || id.length() == 0) {
            return id;
        }
        return String.valueOf(Character.toUpperCase(id.charAt(0))) + id.substring(1);
    }

    private void checkInvalidIdentifiers(AST ast, ActivityType activity) throws CoreException {
        for (DataMappingType dm : activity.getDataMapping()) {
            if (!"default".equals(dm.getContext())) continue;
            String identifier = this.getId(dm);
            try {
                ast.newName(identifier);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.is_not_a_valid_java_identifier, identifier), null));
            }
        }
    }

    private String getId(DataMappingType dm) {
        String id = dm.getId();
        if (id == null) {
            id = dm.getData().getId();
        }
        return id;
    }

    private void checkSourceFolders() throws CoreException {
        IJavaProject project = JavaCore.create((IProject)this.getCurrentProject());
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    return;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Cannot_list_source_folders_for_project, project.getElementName()), (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Project_has_no_source_folders, project.getElementName()), null));
    }

    private IProject getCurrentProject() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileEditorInput editorInput = (FileEditorInput)page.getActiveEditor().getEditorInput();
        IProject project = editorInput.getFile().getProject();
        return project;
    }

    private ActivityType getSelectedActivity() {
        Object selection;
        ActivityType activity = null;
        if (1 == this.getSelectedModelElements().size() && (selection = this.getSelectedModelElements().get(0)) instanceof ActivityType) {
            activity = (ActivityType)selection;
        }
        return activity;
    }

    private ActivitySymbolType getSelectedActivitySymbol(ActivityType activity) {
        for (IGraphicalObject symbol : this.getSelectedSymbols()) {
            if (!(symbol instanceof ActivitySymbolType) || ((ActivitySymbolType)symbol).getActivity() != activity) continue;
            return (ActivitySymbolType)symbol;
        }
        return null;
    }

    protected void doRun() {
    }
}

